% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attrs.R
\name{set_node_attrs}
\alias{set_node_attrs}
\title{Set node attributes}
\usage{
set_node_attrs(x, node_attr, values, nodes = NULL)
}
\arguments{
\item{x}{either a graph object of class
\code{dgr_graph} or a node data frame.}

\item{node_attr}{the name of the attribute to set.}

\item{values}{the values to be set for the chosen
attribute for the chosen nodes.}

\item{nodes}{an optional vector of node IDs for
filtering the list of nodes present in the graph.}
}
\value{
either a graph object of class
\code{dgr_graph} or a node data frame, depending on
what type of object was supplied to \code{x}.
}
\description{
From a graph object of class
\code{dgr_graph} or a node data frame, set node
attribute properties for one or more nodes.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "basic",
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to")

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Set attribute `color = "green"` for
# nodes `1` and `3` using the graph object
graph <-
  set_node_attrs(
    x = graph,
    node_attr = color,
    values = "green",
    nodes = c(1, 3))

# View the graph's node data frame
get_node_df(graph)
#>   id  type label value color
#> 1  1 basic     1   3.5 green
#> 2  2 basic     2   2.6  <NA>
#> 3  3 basic     3   9.4 green
#> 4  4 basic     4   2.7  <NA>

# Set attribute `color = "green"` for
# nodes `1` and `3` using the node data frame
nodes <-
  set_node_attrs(
    x = ndf,
    node_attr = color,
    values = "green",
    nodes = c(1, 3))

# Display the `nodes` ndf
nodes
#>   id  type label value color
#> 1  1 basic     1   3.5 green
#> 2  2 basic     2   2.6  <NA>
#> 3  3 basic     3   9.4 green
#> 4  4 basic     4   2.7  <NA>

# Set attribute `color = "blue"` for
# all nodes in the node data frame
nodes <-
  set_node_attrs(
    x = ndf,
    node_attr = color,
    values = "blue")

# Display the `nodes` ndf
nodes
#>   id  type label value color
#> 1  1 basic     1   3.5  blue
#> 2  2 basic     2   2.6  blue
#> 3  3 basic     3   9.4  blue
#> 4  4 basic     4   2.7  blue
}
