% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cmty_fast_greedy.R
\name{get_cmty_fast_greedy}
\alias{get_cmty_fast_greedy}
\title{Get community membership by modularity optimization}
\usage{
get_cmty_fast_greedy(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame with group membership
assignments for each of the nodes.
}
\description{
Through the use of greedy
optimization of a modularity score, obtain
the group membership values for each of the
nodes in the graph. Note that this method
only works on graphs without multiple edges.
}
\examples{
# Create a graph with a
# balanced tree
graph <-
  create_graph() \%>\%
  add_balanced_tree(
    k = 2,
    h = 2)

# Get the group membership
# values for all nodes in
# the graph through the greedy
# optimization of modularity
# algorithm
graph \%>\%
  get_cmty_fast_greedy()

# Add the group membership
# values to the graph as a
# node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_cmty_fast_greedy(.))

# Display the graph's
# node data frame
graph \%>\%
  get_node_df()
}
