% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_node_attrs_ws.R
\name{get_node_attrs_ws}
\alias{get_node_attrs_ws}
\title{Get node attribute values from a selection of nodes}
\usage{
get_node_attrs_ws(graph, node_attr)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr}{the name of the attribute for which
to get values.}
}
\value{
a named vector of node attribute values for
the attribute given by \code{node_attr} by node ID.
}
\description{
From a graph object of class
\code{dgr_graph}, get node attribute values from nodes
currently active as a selection.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 4,
    m = 4,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = value,
    values = c(2.5, 8.2, 4.2, 2.4))

# Select nodes with ID values
# `1` and `3`
graph <-
  graph \%>\%
  select_nodes_by_id(
    nodes = c(1, 3))

# Get the node attribute values
# for the `value` attribute, limited
# to the current node selection
graph \%>\%
  get_node_attrs_ws(
    node_attr = value)
}
