% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorize_node_attrs.R
\name{colorize_node_attrs}
\alias{colorize_node_attrs}
\title{Apply colors based on node attribute values}
\usage{
colorize_node_attrs(
  graph,
  node_attr_from,
  node_attr_to,
  cut_points = NULL,
  palette = "Spectral",
  alpha = NULL,
  reverse_palette = FALSE,
  default_color = "#D9D9D9"
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr_from}{The name of the node attribute column from which color
values will be based.}

\item{node_attr_to}{The name of the new node attribute to which the color
values will be applied.}

\item{cut_points}{An optional vector of numerical breaks for bucketizing
continuous numerical values available in a edge attribute column.}

\item{palette}{Can either be: (1) a palette name from the RColorBrewer
package (e.g., \code{Greens}, \code{OrRd}, \code{RdYlGn}), (2) \code{viridis}, which indicates
use of the \code{viridis} color scale from the package of the same name, or (3)
a vector of hexadecimal color names.}

\item{alpha}{An optional alpha transparency value to apply to the generated
colors. Should be in the range of \code{0} (completely transparent) to \code{100}
(completely opaque).}

\item{reverse_palette}{An option to reverse the order of colors in the chosen
palette. The default is \code{FALSE}.}

\item{default_color}{A hexadecimal color value to use for instances when the
values do not fall into the bucket ranges specified in the \code{cut_points}
vector.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal node data frame (ndf), use a categorical node
attribute to generate a new node attribute with color values.
}
\examples{
# Create a graph with 8
# nodes and 7 edges
graph <-
  create_graph() \%>\%
  add_path(n = 8) \%>\%
  set_node_attrs(
    node_attr = weight,
    values = c(
      8.2, 3.7, 6.3, 9.2,
      1.6, 2.5, 7.2, 5.4))

# Find group membership values for all nodes
# in the graph through the Walktrap community
# finding algorithm and join those group values
# to the graph's internal node data frame (ndf)
# with the `join_node_attrs()` function
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_cmty_walktrap(.))

# Inspect the number of distinct communities
graph \%>\%
  get_node_attrs(
    node_attr = walktrap_group) \%>\%
  unique() \%>\%
  sort()

# Visually distinguish the nodes in the different
# communities by applying colors using the
# `colorize_node_attrs()` function; specifically,
# set different `fillcolor` values with an alpha
# value of 90 and apply opaque colors to the node
# border (with the `color` node attribute)
graph <-
  graph \%>\%
  colorize_node_attrs(
    node_attr_from = walktrap_group,
    node_attr_to = fillcolor,
    palette = "Greens",
    alpha = 90) \%>\%
  colorize_node_attrs(
    node_attr_from = walktrap_group,
    node_attr_to = color,
    palette = "viridis",
    alpha = 80)

# Show the graph's internal node data frame
graph \%>\% get_node_df()

# Create a graph with 8 nodes and 7 edges
graph <-
  create_graph() \%>\%
  add_path(n = 8) \%>\%
  set_node_attrs(
    node_attr = weight,
    values = c(
      8.2, 3.7, 6.3, 9.2,
      1.6, 2.5, 7.2, 5.4))

# We can bucketize values in `weight` using
# `cut_points` and assign colors to each of the
# bucketed ranges (for values not part of any
# bucket, a gray color is assigned by default)
graph <-
  graph \%>\%
  colorize_node_attrs(
    node_attr_from = weight,
    node_attr_to = fillcolor,
    cut_points = c(1, 3, 5, 7, 9))

# Now there will be a `fillcolor` node attribute
# with distinct colors (the `#D9D9D9` color is
# the default `gray85` color)
graph \%>\% get_node_df()

}
