% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_node_attrs.R
\name{drop_node_attrs}
\alias{drop_node_attrs}
\title{Drop a node attribute column}
\usage{
drop_node_attrs(graph, node_attr)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr}{The name of the node attribute column to drop.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal node data frame (ndf), remove an existing node
attribute.
}
\examples{
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 5,
    m = 10,
    set_seed = 23) \%>\%
 set_node_attrs(
    node_attr = value,
    values = rnorm(
      n = count_nodes(.),
      mean = 5,
      sd = 1) \%>\% round(1))

# Get the graph's internal
# ndf to show which node
# attributes are available
graph \%>\% get_node_df()

# Drop the `value` node
# attribute
graph <-
  graph \%>\%
  drop_node_attrs(
    node_attr = value)

# Get the graph's internal
# ndf to show that the node
# attribute `value` had been
# removed
graph \%>\% get_node_df()

}
