% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_edge.R
\name{add_edge}
\alias{add_edge}
\title{Add an edge between nodes in a graph object}
\usage{
add_edge(graph, from, to, rel = NULL, edge_aes = NULL, edge_data = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{from}{The outgoing node from which the edge is connected. There is the
option to use a node \code{label} value here (and this must correspondingly also
be done for the \code{to} argument) for defining node connections. Note that
this is only possible if all nodes have distinct \code{label} values set and
none exist as an empty string.}

\item{to}{The incoming nodes to which each edge is connected. There is the
option to use a node \code{label} value here (and this must correspondingly also
be done for the \code{from} argument) for defining node connections. Note that
this is only possible if all nodes have distinct \code{label} values set and
none exist as an empty string.}

\item{rel}{An optional string specifying the relationship between the
connected nodes.}

\item{edge_aes}{An optional list of named vectors comprising edge aesthetic
attributes. The helper function \code{\link[=edge_aes]{edge_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted edge aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{penwidth}, \code{color}).}

\item{edge_data}{An optional list of named vectors comprising edge data
attributes. The helper function \code{\link[=edge_data]{edge_data()}} is strongly recommended for
use here as it helps bind data specifically to the created edges.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add an edge to nodes within the
graph.
}
\examples{
# Create a graph with 4 nodes
graph <-
  create_graph() \%>\%
  add_node(label = "one") \%>\%
  add_node(label = "two") \%>\%
  add_node(label = "three") \%>\%
  add_node(label = "four")

# Add an edge between those
# nodes and attach a
# relationship to the edge
graph <-
 add_edge(
   graph,
   from = 1,
   to = 2,
   rel = "A")

# Use the `get_edge_info()`
# function to verify that
# the edge has been created
graph \%>\%
  get_edge_info()

# Add another node and
# edge to the graph
graph <-
  graph \%>\%
  add_edge(
    from = 3,
    to = 2,
    rel = "A")

# Verify that the edge
# has been created by
# counting graph edges
graph \%>\% count_edges()

# Add edges by specifying
# node `label` values; note
# that all nodes must have
# unique `label` values to
# use this option
graph <-
  graph \%>\%
  add_edge(
    from = "three",
    to = "four",
    rel = "L") \%>\%
  add_edge(
    from = "four",
    to = "one",
    rel = "L")

# Use `get_edges()` to verify
# that the edges were added
graph \%>\% get_edges()

# Add edge aesthetic and data
# attributes during edge creation
graph_2 <-
  create_graph() \%>\%
  add_n_nodes(n = 2) \%>\%
  add_edge(
    from = 1,
    to = 2,
    rel = "M",
    edge_aes = edge_aes(
      penwidth = 1.5,
      color = "blue"),
    edge_data = edge_data(
      value = 4.3))

# Use the `get_edges()` function
# to verify that the attribute
# values were bound to the
# newly created edge
graph_2 \%>\% get_edge_df()
}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
