% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_graph_undirected.R
\name{is_graph_undirected}
\alias{is_graph_undirected}
\title{Is the graph an undirected graph?}
\usage{
is_graph_undirected(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A logical value.
}
\description{
Determines whether a graph is set as undirected or not and returns a logical
value to that effect.
}
\examples{
# Create an empty graph; by
# default, new graphs made
# by `create_graph()` are
# directed graph, so, use
# `directed = FALSE` to create
# an undirected graph
graph <-
  create_graph(
    directed = FALSE)

# Determine whether the
# graph is undirected
graph \%>\% is_graph_undirected()

# Use the `set_graph_directed()`
# function and check again
# as to whether the graph is
# undirected
graph \%>\%
  set_graph_directed() \%>\%
  is_graph_undirected()

}
