% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{plot.DiscreteFDR}
\alias{plot.DiscreteFDR}
\title{Plot Method for \code{DiscreteFDR} objects}
\usage{
\method{plot}{DiscreteFDR}(
  x,
  col = c(2, 4, 1),
  pch = c(20, 20, 17),
  lwd = rep(par()$lwd, 3),
  cex = rep(par()$cex, 3),
  type.crit = "b",
  legend = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{DiscreteFDR}.}

\item{col}{numeric or character vector of length 3 indicating the
colors of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present).
}}

\item{pch}{numeric or character vector of length 3 indicating the
point characters of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present and \code{type.crit}
is a plot type like \code{'p'}, \code{'b'} etc.).
}}

\item{lwd}{numeric vector of length 3 indicating the thickness of the
points and lines; defaults to current \code{par()$lwd} setting.}

\item{cex}{numeric vector of length 3 indicating the size of point
characters or lines of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present).
}
defaults to current \code{par()$cex} setting.}

\item{type.crit}{1-character string giving the type of plot desired for the
critical values (e.g.: \code{'p'}, \code{'l'} etc; see \code{\link[=plot]{plot()}}).}

\item{legend}{if \code{NULL}, no legend is plotted; otherwise expecting a
character string like \code{"topleft"} etc. or a numeric vector
of two elements indicating (x, y) coordinates.}

\item{...}{further arguments to \code{\link[=plot.default]{plot.default()}}.}
}
\description{
Plots raw p-values of a \code{DiscreteFDR} object and highlights rejected and
accepted p-values. If present, the critical values are plotted, too.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Compute p-values and their supports of Fisher's exact test
test.result <- generate.pvalues(df, "fisher")
raw.pvalues <- test.result$get_pvalues()
pCDFlist <- test.result$get_pvalue_supports()

DBH.su.fast <- DBH(raw.pvalues, pCDFlist)
DBH.su.crit <- DBH(raw.pvalues, pCDFlist, ret.crit.consts = TRUE)
DBH.sd.fast <- DBH(test.result, direction = "sd")
DBH.sd.crit <- DBH(test.result, direction = "sd", ret.crit.consts = TRUE)

plot(DBH.sd.fast)
plot(DBH.sd.crit, xlim = c(1, 5), ylim = c(0, 0.4))
plot(DBH.su.fast, col = c(2, 4), pch = c(2, 3), lwd = c(2, 2), 
     legend = "topleft", xlim = c(1, 5), ylim = c(0, 0.4))
plot(DBH.su.crit, col = c(2, 4, 1), pch = c(1, 1, 4), lwd = c(1, 1, 2), 
     type.crit = 'o', legend = c(1, 0.4), lty = 1, xlim = c(1, 5), 
     ylim = c(0, 0.4))

}
