% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompBinom.R
\name{CompBinom}
\alias{CompBinom}
\alias{pCompBinom}
\alias{expValCompBinom}
\alias{varCompBinom}
\alias{VatRCompBinom}
\alias{TVatRCompBinom}
\title{Compound Binomial Distribution}
\usage{
pCompBinom(
  x,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

expValCompBinom(
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

varCompBinom(
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

VatRCompBinom(
  kap,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

TVatRCompBinom(
  kap,
  size,
  prob,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  vark,
  k0,
  distr_severity = "Gamma"
)
}
\arguments{
\item{x}{vector of quantiles.}

\item{size}{Number of trials (0 or more).}

\item{prob}{Probability of success in each trial.}

\item{shape}{shape parameter \eqn{\alpha}{alpha}, must be positive.}

\item{rate}{rate parameter \eqn{\beta}{beta}, must be positive.}

\item{scale}{alternative parameterization to the rate parameter, scale = 1 / rate.}

\item{k0}{point up to which to sum the distribution for the approximation.}

\item{distr_severity}{Choice of severity distribution.
\itemize{
 \item{"gamma"} (default)
 \item{"lognormal"} only for the expected value and variance.
}}

\item{kap}{probability.}

\item{vark}{Value-at-Risk (VaR) calculated at the given probability kap.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{pCompBinom}}}{ gives the cumulative density function.}
    \item{\code{\link{expValCompBinom}}}{ gives the expected value.}
    \item{\code{\link{varCompBinom}}}{ gives the variance.}
    \item{\code{\link{TVatRCompBinom}}}{ gives the Tail Value-at-Risk.}
    \item{\code{\link{VatRCompBinom}}}{ gives the Value-at-Risk.}
  }
Returned values are approximations for the cumulative density function,
TVaR, and VaR.
}
\description{
Computes various risk measures (mean, variance, Value-at-Risk (VaR),
and Tail Value-at-Risk (TVaR)) for the compound Binomial distribution.
}
\details{
The compound binomial distribution has density ....
}
\examples{
pCompBinom(x = 2, size = 1, prob = 0.2, shape = log(1000) - 0.405,
          rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

expValCompBinom(size = 1, prob = 0.2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

varCompBinom(size = 1, prob = 0.2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

VatRCompBinom(kap = 0.9, size = 1, prob = 0.2, shape = log(1000) - 0.405,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

vark_calc <- VatRCompBinom(kap = 0.9, size = 1, prob = 0.2, shape = 0.59,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")
TVatRCompBinom(kap = 0.9, size = 1, prob = 0.2, shape = 0.59, rate = 0.9^2,
            vark = vark_calc, k0 = 1E2, distr_severity = "Gamma")

}
