% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AD2gof.R
\name{AD2gof}
\alias{AD2gof}
\title{Two-Sample Anderson-Darling Test (Bootstrap Version)}
\usage{
AD2gof(
  x,
  y,
  alternative = c("two.sided", "less", "greater"),
  nboots = 2000,
  keep.boots = FALSE
)
}
\arguments{
\item{x}{A numeric vector of data values from the first sample.}

\item{y}{A numeric vector of data values from the second sample.}

\item{alternative}{Character string specifying the alternative hypothesis.
One of `"two.sided"` (default), `"less"`, or `"greater"`.}

\item{nboots}{Integer. Number of bootstrap replicates to compute the null distribution (default: 2000).}

\item{keep.boots}{Logical. If `TRUE`, returns the full vector of bootstrap statistics (default: `FALSE`).}
}
\value{
A list of class `"htest"` containing:
\describe{
  \item{statistic}{The observed Anderson-Darling test statistic.}
  \item{p.value}{The estimated bootstrap p-value.}
  \item{alternative}{The alternative hypothesis used.}
  \item{method}{A character string describing the test.}
  \item{bootstraps}{(Optional) A numeric vector of bootstrap statistics if `keep.boots = TRUE`.}
}
}
\description{
Performs a two-sample Anderson-Darling (AD) goodness-of-fit test using bootstrap resampling
to compare whether two samples come from the same distribution. This test is sensitive to
differences in both location and shape between the two distributions.
}
\details{
The test computes the Anderson-Darling statistic using the pooled empirical distribution
functions (ECDFs) of the two samples. A bootstrap procedure resamples the group labels
to approximate the null distribution and compute a p-value. If `p.value = 0`, it is adjusted
to `1 / (2 * nboots)` for stability.
}
\examples{
set.seed(123)
x <- rnorm(100, mean = 0, sd = 4)
y <- rnorm(100, mean = 2, sd = 4)
AD2gof(x, y)

}
