% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelEval.R
\name{visW}
\alias{visW}
\title{Plot the estimates for the latent factors}
\usage{
visW(mcmc.output, Y, D, chain = 1, factors = c(1, 2))
}
\arguments{
\item{mcmc.output}{an mcmc list as produced by clean.mcmc}

\item{Y}{the matrix of data}

\item{D}{the number of latent factors}

\item{chain}{the chain to plot (default = 1)}

\item{factors}{a vector indicating the factors to plot (default = c(1, 2))}
}
\value{
res.W a data frame containing the estimates for the factors, and their lower
and upper bounds

Inertia the percentage of total inertia captured by each of the factors
}
\description{
Plot the estimates for the latent factors
}
\examples{
data("toydata")
data("stanfit")
codafit <- coda.obj(stanfit) ## convert to mcmc.list
W.res <- visW(codafit, Y = toydata$Y.simul$Y, D = toydata$wlu$D,
chain = 1, factors = c(1, 2))

## plot the results

data <- data.frame(time = rep(1:9, 2), W.res$res.W)
ggplot2::ggplot() +
  ggplot2::geom_step(data = data, ggplot2::aes(x = time, y = Estimation, colour = Factor)) +
  ggplot2::geom_step(data = data, ggplot2::aes(x = time, y = Lower.est, colour = Factor),
  linetype = "longdash") +
  ggplot2::geom_step(data = data, ggplot2::aes(x = time, y = Upper.est, colour = Factor),
  linetype = "longdash")

}
\author{
Gabrielle Weinrott
}

