% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presence.R
\name{presence}
\alias{presence}
\title{Active and Passive Presence}
\usage{
presence(drama, passiveOnlyWhenNotActive = TRUE)
}
\arguments{
\item{drama}{A single drama}

\item{passiveOnlyWhenNotActive}{Logical. If true (default), passive presence is only 
counted if a character is not actively present in the scene.}
}
\value{
QDHasCharacter, data.frame. Columns \code{actives}, \code{passives} and 
\code{scenes} show the 
absolute number of scenes in which a character is actively/passively present, or the
total number of scenes in the play. The column \code{presence} is calculated as 
\eqn{\frac{actives-passives}{scenes}}{(actives-passives)/scenes}.
}
\description{
This function should be called for a single text. It returns 
a data.frame with one row for each character in the play. The 
data.frame contains 
information about the number of scenes in which a character is actively 
speaking or passively mentions. Please note that the information about
passive presence is derived from coreference resolved texts, which is a
difficult task and not entirely reliable. The plays included in the package
feature manually annotated coreferences (and thus, the presence is calculated on
the basis of very well data).
}
\examples{
data(rksp.0)
presence(rksp.0)
}
