% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoMAR.R
\name{autoMAR}
\alias{autoMAR}
\title{Function to identify and generate the Missing at Random features (MAR)}
\usage{
autoMAR(
  data,
  aucv = 0.9,
  strataname = NULL,
  stratasize = NULL,
  mar_method = "glm"
)
}
\arguments{
\item{data}{[data.frame | Required] dataframe or data.table}

\item{aucv}{[integer  | Optional] auc cut-off value for the not missing at random variable selection}

\item{strataname}{[text  | Optional] vector of stratification variables}

\item{stratasize}{[integer  | Optional] vector of stratum sample sizes (in the order in which the strata are given in the input dataset).}

\item{mar_method}{[text  | Optional] missing at random classification method ("glm", "rf"). Default GLM is used (GLM runs faster for high dimensional data)}
}
\value{
list output including missing variable summary and number of MAR flag variables
}
\description{
This function will automatically identify the missing patterns and flag the variables if they are not missing at random based on the AUC method
}
\examples{
# create missing at random features
marobj <- autoMAR (heart, aucv = 0.9, strataname = NULL, stratasize = NULL, mar_method = "glm")
}
