% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictDataprep.R
\name{predictDataprep}
\alias{predictDataprep}
\title{Extract predictions and generate columns from autoDataprep objects}
\usage{
predictDataprep(x, data)
}
\arguments{
\item{x}{[autoDataprep object  | Required] autoDataprep object for which prediction is desired}

\item{data}{[data.frame | Required] prediction data set to prepare the MAR columns}
}
\value{
master data set same as train data set
}
\description{
this function can be used for autoDataprep objects to generate the same for validation
}
\examples{
## Sample train data set
train <- heart[1:200, ]
test <- heart[201:350, ]
traindata <- autoDataprep(train, target = "target_var", missimpute = "default",
dummyvar = TRUE, aucv = 0.02, corr = 0.98, outlier_flag = TRUE,
interaction_var = TRUE, frequent_var = TRUE)
train <- traindata$master

## Predict same features for test set
test <- predictDataprep(traindata, test)

}
