% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDrugUtilisationCohortSet.R
\name{generateDrugUtilisationCohortSet}
\alias{generateDrugUtilisationCohortSet}
\title{Generates a cohort of the drug use of a certain list of concepts.}
\usage{
generateDrugUtilisationCohortSet(
  cdm,
  name,
  conceptSet,
  durationRange = c(1, Inf),
  imputeDuration = "none",
  gapEra = 0,
  priorUseWashout = 0,
  priorObservation = 0,
  cohortDateRange = as.Date(c(NA, NA)),
  limit = "all"
)
}
\arguments{
\item{cdm}{A cdm_reference object.}

\item{name}{Name of the GeneratedCohortSet}

\item{conceptSet}{Named list of concept sets.}

\item{durationRange}{Range between the duration must be comprised. It should
be a numeric vector of length two, with no NAs and the first value should be
equal or smaller than the second one. It is only required if imputeDuration
= TRUE. If NULL no restrictions are applied.}

\item{imputeDuration}{Whether/how the duration should be imputed
"none", "median", "mean", "mode", or it can be a count}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{priorUseWashout}{Prior days without exposure.}

\item{priorObservation}{Minimum number of days of prior observation
required for the incident eras to be considered.}

\item{cohortDateRange}{Range for cohort_start_date and cohort_end_date}

\item{limit}{Choice on how to summarise the exposures. There are
two options:
"all" we summarise the output will be a summary of the exposed eras of
each individual. Each individual can contribute multiple times.
"first" we only consider the first observable era of each individual that fulfills the criteria provided
in previous parameters. In this case each individual can not contribute with multiple rows.}
}
\value{
The function returns the 'cdm' object with the created tables as
references of the object.
}
\description{
Generates a cohort of the drug use of a certain list of concepts.
}
\examples{
\donttest{
library(CodelistGenerator)
library(CDMConnector)
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

druglist <- getDrugIngredientCodes(cdm, c("acetaminophen", "metformin"))

cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "drug_cohorts",
  conceptSet = druglist,
  priorObservation = 365
)

cdm[["drug_cohorts"]]

cohortSet(cdm[["drug_cohorts"]])

cohortCount(cdm[["drug_cohorts"]])

cohortAttrition(cdm[["drug_cohorts"]])
}

}
