% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotObserved.R
\name{plotObserved}
\alias{plotObserved}
\title{Plot quantiles of data against model implied quantiles.}
\usage{
plotObserved(resObserved, data, what = c("cr", "c", "r"), layout = NULL,
  main = NULL, linesArgs = list(), ggplot = FALSE, prob = seq(0, 1,
  0.01), probType = 3, ...)
}
\arguments{
\item{resObserved}{output of \code{\link{estObserved}}.}

\item{data}{The dataset used to estimate the model.}

\item{what}{What to plot. Can be 'cr' for 'condition-response pairs,
'c' for condition, and 'r' for response.}

\item{layout}{An optional layout matrix.}

\item{main}{an optional vector containing names for each plot.}

\item{linesArgs}{A list containing named arguments to be passed to \code{\link{lines}}.}

\item{ggplot}{Deprecated and ignored.}

\item{prob}{Should a qqplot of observed vs model implied quantiles be plotted?
By default, it is \code{seq(0, 1, .01)}, the probabilities between 0 and 1 to compare the
model implied quantiles to the observed quantiles. If this argument is NULL,
then a histogram overlayed with model implied densities will be plotted.
Internally, \code{\link{estQdf}} is used for generating quantiles.}

\item{probType}{A numeric value defining several plotting options. 0 does nothing, 1
removes the 0\% quantile, 2 removes the 100\% quantile and 3 removes both the 0\% and 100\% quantile.}

\item{...}{Further arguments to be passed to hist.}
}
\value{
if ggplot is FALSE \code{invisible()}, otherwise a list
}
\description{
Plots histograms for each condition-response pair/ condition/ response
with overlayed estimated densities.
}
\details{
Keep in mind when using \code{what = 'c'} or \code{what = 'r'} pdfs are simply
averaged, not weighted to the number of observed responses.
}
\examples{
# simulate data with three stimuli of different difficulty.
# this implies different drift rates across conditions.
# define a time grid. A more reasonable stepsize is .01; this is just for speed.
tt = seq(0, 5, .1)
pars = c(.8, 2, .5, .5, .5, # condition 1
        .8, 3, .5, .5, .5, # condition 2
        .8, 4, .5, .5, .5) # condition 3
pdfND = dbeta(tt, 10, 30)
# simulate data
lst = simData(n = 3e5, pars = pars, tt = tt, pdfND = pdfND, return.pdf = TRUE)
dat = lst$dat
# define restriction matrix
restr = matrix(1:5, 5, 3)
restr[2, 2:3] = 6:7 # allow drift rates to differ
# fix variance parameters
fixed = matrix(c('sz1', .5, 'sv1', .5), 2, 2)
\dontrun{
# Run D*M analysis
resD = estDstarM(dat = dat, tt = tt, restr = restr, fixed = fixed)
# Estimate nondecision density
resND = estND(resD)
# Estimate observed density
resObs = estObserved(resD, resND)
# plot histograms with overlayed
# densities per condition-response pair
plotObserved(resObserved = resObs, data = dat,
            xlim = c(0, 1))
# plot estimated and true densities
plot(resObs, col = rep(1:3, each = 2), xlim = 0:1)
matlines(tt, lst$pdfNormalized, col = rep(1:3, each = 2), lty = 2)
# other uses of plotObserved
plotObserved(resObserved = resObs, data = dat, what = 'cr', xlim = c(0, 1))
plotObserved(resObserved = resObs, data = dat, what = 'c', xlim = c(0, 1))
plotObserved(resObserved = resObs, data = dat, what = 'r', xlim = c(0, 1))
}
}
