% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BS_fit.R
\name{BS_fit}
\alias{BS_fit}
\title{Fit Black-Scholes Parameters}
\usage{
BS_fit(S, D, T., r, time, dt, vol_start, method = c("iterative", "mle"),
  tol = 1e-12, eps = 1e-08)
}
\arguments{
\item{S}{numeric vector with observed stock prices.}

\item{D}{numeric vector or scalar with debt due in \code{T.}.}

\item{T.}{numeric vector or scalar with time to maturity.}

\item{r}{numeric vector or scalar with risk free rates.}

\item{time}{numeric vector with the observation times.}

\item{dt}{numeric scalar with time increments between observations.}

\item{vol_start}{numeric scalar with starting value for \eqn{\sigma}.}

\item{method}{string to specify which estimation method to use.}

\item{tol}{numeric scalar with tolerance in \code{\link{get_underlying}}.}

\item{eps}{convergence threshold.}
}
\value{
A list with the following components
\item{ests}{estimates of \eqn{\sigma}, and drift, \eqn{\mu}.}
\item{n_iter}{number of iterations when \code{method = "iterative"}
and number of log likelihood evaluations when \code{method = "mle"}.}
\item{success}{logical for whether the estimation method converged.}
}
\description{
Function to estimate the volatility, \eqn{\sigma}, and drift, \eqn{\mu}. See
\code{vignette("Distance-to-default", package = "DtD")} for details. All
vectors with length greater than one needs to have the same length. The
Nelder-Mead method from \code{\link{optim}} is used when
\code{method = "mle"}. Either \code{time} or \code{dt} should be passed.
}
\examples{
library(DtD)
set.seed(83486778)
sims <- BS_sim(
  vol = .1, mu = .05, dt = .1, V_0 = 100, T. = 1, D = rep(80, 20), r = .01)

with(sims,
     BS_fit(S = S, D = D, T. = T, r = r, time = time, method = "mle"))

}
