% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INMB.R
\docType{class}
\name{INMB}
\alias{INMB}
\title{A Reference Class to represent the INMB (Incremental Net Monetary Benefit)}
\description{
The net monetary benefit (NMB) of an intervention is given by E x Lambda - C,
where E and C are the effectiveness and cost of this intervention, and Lambda is the threshold value for a unit of effectiveness,
the ceiling incremental cost-effectiveness ratio. When the NMB is positive, the value of the intervention's effectiveness overpasses its cost.
When evaluating the cost-effectiveness of a new intervention in comparison with the reference, one can estimate the difference between the net monetary benefit of the new or experimental intervention
(NMBn) and the net monetary benefit of the reference (NMBr). This difference is known as the incremental net monetary benefit (INMB), which is given by: INMB = NMBn - NMBr = de x lambda - dc.
The new intervention is cost-effective if INMB is positive.
}
\section{Fields}{

\describe{
\item{\code{de}}{: Expected point estimate of the difference in mean effectiveness (effectiveness in the experimental group minus effectiveness in the reference group)}

\item{\code{dc}}{: Expected point estimate of the difference in mean cost (cost in the experimental group minus cost in the reference group)}

\item{\code{object_lambda}}{: object containing the ceiling cost-effectiveness ratio or maximum acceptable cost of a unit of effectiveness. See \link{create_object_lambda}}
}}
\section{Methods}{

 \describe{
 \item{get_inmb():}{Returns the calculated Incremental Net Monetary Benefit (inmb)}
 \item{set_dc(dc):}{sets the dc of this INMB object}
 \item{set_de(de):}{sets the de of this INMB object}
 \item{set_object_lambda(object_lambda):}{sets the object_lambda of this INMB object}
 }
}
\examples{
## First, create a lambda object
object_lambda <- create_object_lambda (20000)
## Then, create an inmb object
object_inmb <- create_object_inmb(de = 0.04, dc=-168, object_lambda = object_lambda)
## inmb is calculated by methods inside the object. Retrieve the inmb :
object_inmb$get_inmb()
}
\seealso{
\link{INMB_DIRECT} the parent class

\link{create_object_inmb} the constructor
}

