% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POP.R
\name{create_object_pop}
\alias{create_object_pop}
\title{Create an object POP}
\usage{
create_object_pop(horizon, discount, N_year)
}
\arguments{
\item{horizon}{: Time horizon in years considered in the estimation of the EVPI.
Finite time horizons are recommended in order to control for the complex and uncertain process of future changes.
Furthermore, because of discounting, the impact of a time horizon over 15 or 20 years on the estimation of EVPI is insignificant.}

\item{discount}{: Annual discount rate considered in the estimation of the EVPI. The annual discount rate is defined in each country, usually within 3 to 6\%.}

\item{N_year}{: Number of individuals likely to be targeted by the evaluated intervention each year}
}
\value{
create_object_pop returns an object of class \link{POP}
}
\description{
The expected value of perfect information (EVPI) is estimated for the entire population targeted by the evaluated intervention.
This object represents this target population. The size of the target population (POP) can be estimated through prevalence and incidence data from registries,
large cohort studies, medico-administrative databases, or surveillance systems.
POP has to be calculated over the entire time horizon used for the estimation of the EVPI.
It is usually easier to gather data on the annual number of individual susceptible to benefit for the new intervention.
If this number is expected to be constant over the time horizon, POP is the product of this time horizon (in years) and the annual number of individual.
If the time horizon is longer than one year, POP has to be discounted.
}
\examples{
object_pop <- create_object_pop(horizon = 20, discount=0.04, N_year = 52000)
}

