% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.r
\name{check_ecotox_availability}
\alias{check_ecotox_availability}
\title{Check whether a ECOTOX database exists locally}
\usage{
check_ecotox_availability(target = get_ecotox_path())
}
\arguments{
\item{target}{A \code{character} string specifying the path where to look for the database file.}
}
\value{
Returns a \code{logical} value indicating whether a copy of the database exists. It also returns
a \code{files} attribute that lists which copies of the database are found.
}
\description{
Tests whether a local copy of the US EPA ECOTOX database exists in \code{\link{get_ecotox_path}}.
}
\details{
When arguments are omitted, this function will look in the default directory (\code{\link{get_ecotox_path}}).
However, it is possible to build a database file elsewhere if necessary.
}
\examples{
check_ecotox_availability()
}
\author{
Pepijn de Vries
}
