% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.r
\name{download_ecotox_data}
\alias{download_ecotox_data}
\title{Download and extract ECOTOX database files and compose database}
\usage{
download_ecotox_data(
  target = get_ecotox_path(),
  write_log = TRUE,
  ask = TRUE,
  verify_ssl = getOption("ECOTOXr_verify_ssl"),
  ...
)
}
\arguments{
\item{target}{Target directory where the files will be downloaded and the database compiled. Default is
\code{\link[=get_ecotox_path]{get_ecotox_path()}}.}

\item{write_log}{A \code{logical} value indicating whether a log file should be written to the target path
\code{TRUE}.}

\item{ask}{There are several steps in which files are (potentially) overwritten or deleted. In those cases
the user is asked on the command line what to do in those cases. Set this parameter to \code{FALSE} in order
to continue without warning and asking.}

\item{verify_ssl}{When set to \code{FALSE} the SSL certificate of the host (EPA)
is not verified. Can also be set as option:
\code{options(ECOTOXr_verify_ssl = TRUE)}. Default is \code{TRUE}.}

\item{...}{Arguments passed on to \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} In order for this package to fully function, a local copy of the ECOTOX database
needs to be build. This function will download the required data and build the database.
}
\details{
This function will attempt to find the latest download url for the ECOTOX database from the
\href{https://cfpub.epa.gov/ecotox/index.cfm}{EPA website} (see \code{\link[=get_ecotox_url]{get_ecotox_url()}}).
When found it will attempt to download the zipped archive containing all required data. This data is then
extracted and a local copy of the database is build.

Use '\code{\link[=suppressMessages]{suppressMessages()}}' to suppress the progress report.
}
\section{Known issues}{

On some machines this function fails to connect to the database download URL from the
\href{https://cfpub.epa.gov/ecotox/index.cfm}{EPA website} due to missing
SSL certificates. Unfortunately, there is no easy fix for this in this package. A work around is to download and
unzip the file manually using a different machine or browser that is less strict with SSL certificates. You can
then call \code{\link[=build_ecotox_sqlite]{build_ecotox_sqlite()}} and point the \code{source} location to the manually extracted zip
archive. For this purpose \code{\link[=get_ecotox_url]{get_ecotox_url()}} can be used. Alternatively, one could try to call \code{\link[=download_ecotox_data]{download_ecotox_data()}}
by setting \code{verify_ssl = FALSE}; but only do so when you trust the download URL from \link[=get_ecotox_url]{get_ecotox_URL()}.
}

\examples{
\dontrun{
## This will download and build the database in your temp dir:
download_ecotox_data(tempdir())
}
}
\author{
Pepijn de Vries
}
