Sys.setenv(LANGUAGE = "en")
Sys.setenv(TZ="Europe/Paris")


options(
  encoding="UTF-8",
  # warn=0, #default, stacks
  warn=1, #immediate.=TRUE
  # warn=2, #error
  # warnPartialMatchArgs=TRUE,
  # warnPartialMatchAttr=TRUE,
  # warnPartialMatchDollar=TRUE,
  stringsAsFactors=FALSE,
  dplyr.summarise.inform=FALSE,
  # conflicts.policy="depends.ok",
  tidyverse.quiet=TRUE,
  tidyselect_verbosity ="verbose",#quiet or verbose
  lifecycle_verbosity="warning", #NULL, "quiet", "warning" or "error"
  testthat.progress.max_fails = 50
)

library(rlang, warn.conflicts=FALSE)

options(trialmaster_pw="0")
# getOption("trialmaster_pw")

# cachename="trialmaster_export_2022-08-25 15h16.rds"
# filename="CRF_Dan_Export_SAS_XPORT_2022_08_25_15_16.zip"
# filename_noformat="CRF_Dan_Export_SAS_XPORT_2022_08_25_15_16_noformat.zip"
# filename_nopw="CRF_Dan_Export_SAS_XPORT_2022_08_25_15_16_nopw.zip"
# filename_bad="CRF_Dan_Export.zip"


cachename = test_path("trialmaster_export_2022-08-25 15h16.rds")
filename = test_path("CRF_Dan_Export_SAS_XPORT_2022_08_25_15_16.zip")
filename_noformat = test_path("CRF_Dan_Export_SAS_XPORT_2022_08_25_15_16_noformat.zip")
filename_nopw = test_path("CRF_Dan_Export_SAS_XPORT_2022_08_25_15_16_nopw.zip")
filename_bad = test_path("CRF_Dan_Export.zip")


# print("uhuhhuhu")
# print(is_testing())
# print("uhuhhuhu")

# if(!is_testing()){
#   cachename=paste0("tests/testthat/", cachename)
#   filename=paste0("tests/testthat/", filename)
#   filename_noformat=paste0("tests/testthat/", filename_noformat)
#   filename_nopw=paste0("tests/testthat/", filename_nopw)
#   filename_bad=paste0("tests/testthat/", filename_bad)
# }

clean_cache = function(){
  if(file.exists(cachename)) file.remove(cachename)
  options(edc_lookup=NULL)
}
v=utils::View


snapshot_review_bg = function(...){
  # brw = function(url) .Call("rs_browseURL", url, PACKAGE="(embedding)")
  brw = Sys.getenv("R_BROWSER")
  callr::r_bg(function() testthat::snapshot_review(...),
              package=TRUE,
              env = c(R_BROWSER = brw))
}

temp_target = function(name){
  target = file.path2(tempdir(), "name")
  unlink(target, recursive=TRUE)
  dir.create(target, showWarnings=FALSE)
  target
}

is_testing_in_buildpane = function(){
  # Sys.getenv("RSTUDIO_CHILD_PROCESS_PANE") =="build"
  
  # print("----------")
  # # print(Sys.getenv("RSTUDIO_CHILD_PROCESS_PANE"))
  # print(getwd())
  # print(Sys.getenv())
  # print("----------")
  
  str_ends(getwd(), "testthat/?")
}

expect_classed_conditions = function(expr, message_class=NULL, warning_class=NULL, error_class=NULL){
  dummy = c("rlang_message", "message", "rlang_warning", "warning", "rlang_error", "error", "condition")
  ms = list()
  ws = list()
  es = list()
  x = withCallingHandlers(
    withRestarts(expr, muffleStop=function() "expect_classed_conditions__error"),
    message=function(m){
      ms <<- c(ms, list(m))
      invokeRestart("muffleMessage")
    },
    warning=function(w){
      ws <<- c(ws, list(w))
      invokeRestart("muffleWarning")
    }, 
    error=function(e){
      es <<- c(es, list(e))
      invokeRestart("muffleStop")
    }
  )
  
  f = function(cond_list, cond_class){
    cl = map(cond_list, class) %>% purrr::flatten_chr()
    missing = setdiff(cl, cond_class) %>% setdiff(dummy)
    extra = setdiff(cond_class, cl) %>% setdiff(dummy)
    if(length(missing)>0 || length(extra)>0){
      cli_abort(c("{.arg {caller_arg(cond_class)}} is not matching thrown conditions:",
                  i="Missing expected classes: {.val {missing}}",
                  i="Extra unexpected classes: {.val {extra}}"), 
                call=rlang::caller_env())
    }
  }
  f(es, error_class)
  f(ws, warning_class)
  f(ms, message_class)
  x
}

clean_cache()
message("Helper-init loaded")
