% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProposeDiscrete.R
\name{ProposeDiscrete}
\alias{ProposeDiscrete}
\title{Propose a new discrete value.}
\usage{
ProposeDiscrete(params.old, proposal.range, max.range)
}
\arguments{
\item{params.old}{Old parameter value (an integer).}

\item{proposal.range}{Range for new proposal (an integer).}

\item{max.range}{Maximum value for new proposal (an integer).}
}
\value{
Returns the new proposed parameter, which will be an integer in the
range [0, \code{max.range}], and within at most \code{proposal.range} of
\code{params.old}.
}
\description{
This function proposes a new discrete parameter, based on the previous
value, within the given proposal range, making sure that the maximum range
is not exceeded.
}
\examples{

# Previous parameter value
param = rpois(1, 5)

# Propose new value within range [0, 10], with proposal width 2
new.param = ProposeDiscrete(param, 2, 10)

}
\author{
Frank Dondelinger
}
\seealso{
\code{\link{proposeContinuous}}
}

