% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdm_ica.R
\name{mdm_ica}
\alias{mdm_ica}
\title{Independent Component Analysis via Mutual Dependence Measures}
\usage{
mdm_ica(X, num_lhs = NULL, type = "comp", num_bo = NULL, kernel = "exp",
  algo = "par")
}
\arguments{
\item{X}{A matrix or data frame, where rows represent samples, and columns represent components.}

\item{num_lhs}{The number of points generated by Latin hypercube sampling.
If omitted, an adaptive number is used.}

\item{type}{The type of mutual dependence measures, including
\itemize{
  \item \code{asym}: asymmetric measure \eqn{\mathcal{R}_n} based on distance covariance 
    \eqn{\mathcal{V}_n};
  \item \code{sym}: symmetric measure \eqn{\mathcal{S}_n} based on distance covariance 
    \eqn{\mathcal{V}_n};
  \item \code{comp}: simplified complete measure \eqn{\mathcal{Q}_n^\star} based on 
    incomplete V-statistics;
  \item \code{dhsic}: d-variable Hilbert--Schmidt independence criterion dHSIC\eqn{_n} based on 
    Hilbert--Schmidt independence criterion HSIC\eqn{_n}. 
}}

\item{num_bo}{The number of points evaluated by Bayesian optimization.}

\item{kernel}{The kernel of the underlying Gaussian process in Bayesian optimization, including
\itemize{
  \item \code{exp}: squared exponential kernel;
  \item \code{mat}: Matern 5/2 kernel.
}}

\item{algo}{The algorithm of optimization, including
\itemize{
  \item \code{def}: deflation algorithm, where the components are extracted one at a time;
  \item \code{par}: parallel algorithm, where the components are extracted simultaneously.
}}
}
\value{
\code{mdm_ica} returns a list including the following components:
\item{theta}{The rotation angles of the estimated unmixing matrix.}
\item{W}{The estimated unmixing matrix.}
\item{obj}{The objective value of the estimated independence components.}
\item{S}{The estimated independence components.}
}
\description{
\code{mdm_ica} performs independent component analysis by minimizing mutual dependence measures 
of all univariate components in \code{X}.
}
\examples{
# X is a 10 x 3 matrix with 10 samples and 3 components
X <- matrix(rnorm(10 * 3), 10, 3)

# deflation algorithm
mdm_ica(X, type = "asym", algo = "def")
# parallel algorithm
mdm_ica(X, type = "asym", algo = "par")

\dontrun{
# bayesian optimization with exponential kernel
mdm_ica(X, type = "sym", num_bo = 1, kernel = "exp", algo = "par")
# bayesian optimization with matern kernel
mdm_ica(X, type = "comp", num_bo = 1, kernel = "mat", algo = "par")
}
}
\references{
Jin, Z., and Matteson, D. S. (2017).
  Generalizing Distance Covariance to Measure and Test Multivariate Mutual Dependence.
  arXiv preprint arXiv:1709.02532.
  \url{https://arxiv.org/abs/1709.02532}.

Pfister, N., et al. (2018).
  Kernel-based tests for joint independence.
  Journal of the Royal Statistical Society: Series B (Statistical Methodology), 80(1), 5-31.
  \url{http://dx.doi.org/10.1111/rssb.12235}.
}
