% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropyFit.R
\name{entropyFit}
\alias{entropyFit}
\title{Entropy Fit Index}
\usage{
entropyFit(data, structure)
}
\arguments{
\item{data}{A dataset}

\item{structure}{A vector representing the structure (numbers or labels for each item).
Can be theoretical factors or the structure detected by \code{\link{EGA}}}
}
\value{
Returns a list containing:

\item{Total.Correlation}{The total correlation of the dataset}

\item{Total.Correlation.MM}{Miller-Madow correction for the total correlation of the dataset}

\item{Entropy.Fit}{The Entropy Fit Index}

\item{Entropy.Fit.MM}{Miller-Madow correction for the Entropy Fit Index}

\item{Average.Entropy}{The average entropy of the dataset}
}
\description{
Computes the fit of a dimensionality structure using empirical entropy.
Lower values suggest better fit of a structure to the data.
}
\examples{
\donttest{
#estimate EGA model
ega.wmt <- EGA(data = wmt2[,7:24], model = "glasso")

#compute entropy indices
entropyFit(data = wmt2[,7:24], structure = ega.wmt$wc)
}
}
\seealso{
\code{\link{EGA}} to estimate the number of dimensions of an instrument using EGA and \code{\link{CFA}} to
verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
