% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vn.entropy.R
\name{vn.entropy}
\alias{vn.entropy}
\title{Entropy Fit Index using Von Neumman's entropy (Quantum Information Theory) for correlation matrices}
\usage{
vn.entropy(data, structure)
}
\arguments{
\item{data}{A dataset or a correlation matrix}

\item{structure}{A vector representing the structure (numbers or labels for each item).
Can be theoretical factors or the structure detected by \code{\link{EGA}}}
}
\value{
Returns a list containing:

\item{Entropy.Fit}{The Entropy Fit Index using Von Neumman's entropy}

\item{Total.Correlation}{The total correlation of the dataset}

\item{Average.Entropy}{The average entropy of the dataset}
}
\description{
Computes the fit of a dimensionality structure using Von Neumman's entropy when the input is a correlation matrix.
Lower values suggest better fit of a structure to the data.
}
\examples{
\donttest{
#estimate EGA model
ega.wmt <- EGA(data = wmt2[,7:24], model = "glasso")

#compute entropy indices
vn.entropy(data = wmt2[,7:24], structure = ega.wmt$wc)
}
}
\seealso{
\code{\link{EGA}} to estimate the number of dimensions of an instrument using EGA and \code{\link{CFA}} to
verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
