% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmi.R
\name{cmi}
\alias{cmi}
\title{Conditional Mutual Information}
\usage{
cmi(data, network = FALSE, EGA = TRUE, steps = 4, scale = TRUE)
}
\arguments{
\item{data}{A dataframe with the variables to be used in the analysis or a correlation matrix.}

\item{network}{Logical.
If TRUE, returns a plot of the conditional mutual information network.
Defaults to FALSE.}

\item{EGA}{Logical.
If TRUE, exploratory graph analysis is performed using the conditional mutual information network.}

\item{steps}{Number of steps to be used in \code{\link[igraph]{cluster_walktrap}} algorithm (necessary only if the EGA argument is set to TRUE).
Defaults to 4.}

\item{scale}{Logical.
If TRUE, the conditional mutual information will be scaled using the following formula: trace(X)/p, where X is the matrix with the conditional
mutual information and p is the number of variables.}
}
\description{
Computes the conditional mutual information metric using a modification of the matrix of partial correlations (see Zhao, Zhou,Zhang, & Chen, 2016).
If the raw data is provided, the correlation matrix will be computed using the \code{\link[qgraph]{cor_auto}} function of the \code{\link[qgraph]{qgraph}} package.
}
\references{
Zhao, J., Zhou, Y., Zhang, X., & Chen, L. (2016).
Part mutual information for quantifying direct associations in networks.
\emph{Proceedings of the National Academy of Sciences}, \emph{113(18)}, 5130-5135.
}
\seealso{
\code{\link{bootEGA}} to investigate the stability of EGA's estimation via bootstrap
and \code{\link{EGA}} to apply the exploratory graph analysis techinique.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
