% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.scores.R
\name{net.scores}
\alias{net.scores}
\title{Network Scores}
\usage{
net.scores(data, A, wc, global = FALSE, impute, ...)
}
\arguments{
\item{data}{Matrix or data frame.
Must be a dataset}

\item{A}{Matrix, data frame, or \code{\link[EGAnet]{EGA}} object.
An adjacency matrix of network data}

\item{wc}{Numeric.
A vector of community assignments.
Not necessary if an \code{\link[EGAnet]{EGA}} object
is input for argument \code{A}}

\item{global}{Boolean.
Should general network loadings be computed in scores?
Defaults to \code{FALSE}.
If there is more than one dimension and there is theoretically
one global dimension, then general loadings of the dimensions
onto the global dimension can be included in the weighted
scores}

\item{impute}{Character.
In the presence of missing data, imputation can be implemented. Currently,
three options are available:

\itemize{

\item{\strong{\code{none}}}
{No imputation is performed. This is the default.}

\item{\strong{\code{mean}}}
{The "mean" value of the columns are used to replace the missing data.}

\item{\strong{\code{median}}}
{The "median" value of the columns are used to replace the missing data.}

}}

\item{...}{Additional arguments for \code{\link[EGAnet]{EGA}}}
}
\value{
Returns a list containing:

\item{unstd.scores}{The unstandardized network scores for each participant
and community (including the overall score)}

\item{std.scores}{The standardized network scores for each participant
and community (including the overall score)}

\item{commCor}{Partial correlations between the specified or identified communities}

\item{loads}{Standardized network loadings for each item in each dimension
(computed using \code{\link[EGAnet]{net.loads}})}
}
\description{
This function computes network scores computed based on
each node's \code{\link[NetworkToolbox]{strength}} within each
community (i.e., factor) in the network (see \code{\link[EGAnet]{net.loads}}).
These values are used as network "factor loadings" for the weights of each item.
Notably, network analysis allows nodes to contribution to more than one community.
These loadings are considered in the network scores. In addition,
if the construct is a hierarchy (e.g., personality questionnaire;
items in facet scales in a trait domain), then an overall
score can be computed (see argument \code{global}). An important difference
is that the network scores account for cross-loadings in their
estimation of scores
}
\details{
For more details, type \code{vignette("Network_Scores")}
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\dontrun{
 # Estimate EGA
 ega.wmt <- EGA(wmt)
}

# Network scores
net.scores(data = wmt, A = ega.wmt)

}
\references{
Christensen, A. P., & Golino, H. (2021).
On the equivalency of factor and network loadings.
\emph{Behavior Research Methods}.
\doi{10.3758/s13428-020-01500-6}

Christensen, A. P., Golino, H., & Silvia, P. J. (in press).
A psychometric network perspective on the measurement and assessment of personality traits.
\emph{European Journal of Personality}.
\doi{10.1002/per.2265}

Golino, H., Christensen, A. P., Moulder, R., Kim, S., & Boker, S. M. (under review).
Modeling latent topics in social media using Dynamic Exploratory Graph Analysis: The case of the right-wing and left-wing trolls in the 2016 US elections.
\emph{PsyArXiv}.
\doi{10.31234/osf.io/tfs7c}
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com> and Hudson F. Golino <hfg9s at virginia.edu>
}
