% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kalman_functions.R
\name{plotTimeSlice}
\alias{plotTimeSlice}
\title{plotTimeSlice}
\usage{
plotTimeSlice(eList, start = NA, end = NA, conc = TRUE, fluxUnit = 3,
  usgsStyle = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. This
eList must be run through \code{WRTDSKalman}.}

\item{start}{numeric start of DecYear for plot. If \code{NA}, plot will start at the earliest date in the record.}

\item{end}{numeric end of DecYear for plot. If \code{NA}, plot will end at the latest date in the record.}

\item{conc}{logical. If \code{TRUE}, plot concentration, otherwise plot flux.}

\item{fluxUnit}{number representing entry in pre-defined fluxUnit class array. \code{\link{printFluxUnitCheatSheet}}}

\item{usgsStyle}{logical option to use USGS style guidelines. Setting this option
to TRUE does NOT guarantee USGS compliance. It will only change automatically
generated labels}
}
\description{
Plot of either concentration or flux over time showing both the WRTDS and WRTDSKalman estimates.
}
\details{
In the plot title, Ratio of means is mean of WRTDSKalman estimates to the WRTDS Classic estimates.  Ratio only calculated on the data shown in the figure, not the whole series.
In the plot, red dots are measured values, blue dots are plotted at the reporting limit for those values that are censored.
}
\examples{
eList <- Choptank_eList
eList <- WRTDSKalman(eList, niter = 10)

plotTimeSlice(eList, start = 1990, end = 1991, conc = TRUE)

plotTimeSlice(eList, start = 1990, end = 1991, conc = FALSE)

plotTimeSlice(eList, start = NA, end = 1991, conc = FALSE)

}
