% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELMSO.R
\name{reach.ELMSO.fixed}
\alias{reach.ELMSO.fixed}
\title{Calculating Reach from Fixed ELMSO Function}
\usage{
reach.ELMSO.fixed(CPM, w, z, tau = NULL)
}
\arguments{
\item{CPM}{A p-dimensional vector of the fixed CPM at each website for a particular budget value}

\item{w}{A p-dimensional vector of amount spent at each website}

\item{z}{An n by p matrix of pageviews}

\item{tau}{A p-dimensional vector of total pageviews (in thousands) for each website. Defaults to the total pageviews in the matrix for each website (i.e., assumes z matrix represents all website pageviews) divided by 1000.}
}
\value{
A value between 0 and 1 specifying the reach achieved with the given budget allocation.
}
\description{
This function allows you to calculate reach achieved at a given budget value from the fixed ELMSO output.
}
\examples{
z=matrix(round(abs(rnorm(5000,0,0.7))),1000,5)
CPM.fixed=c(3,4,5,6,7)
tau.values=rep(100,5) #Note tau here is in thousands of pageviews

allocation=ELMSO.fixed(z=z,CPM=CPM.fixed,tau=tau.values)
reach.ELMSO.fixed(CPM.fixed,allocation$spend[,101],z,tau.values)


}
\references{
Courtney Paulson, Lan Luo, and Gareth M. James (2018) Efficient Large-Scale Internet Media Selection Optimization for Online Display Advertising. Journal of Marketing Research: August 2018, Vol. 55, No. 4, pp. 489-506.
}
