% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.units.R
\name{convert.units}
\alias{convert.units}
\title{Convert between phi and micrometers.}
\usage{
convert.units(phi, mu)
}
\arguments{
\item{phi}{\code{Numeric} vector, grain-size class values in phi to be
converted.}

\item{mu}{\code{Numeric} vector, grain-size class values in micrometres 
to be converted.}
}
\value{
\code{Numeric} vector, converted grain-size class values.
}
\description{
The function converts values from the phi-scale to the micrometer-scale and
vice versa.
}
\examples{

## generate phi-values
phi <- -2:5

## convert and show phi to mu
mu  <- convert.units(phi = phi)
mu

## convert and show mu to phi
convert.units(mu = mu)

}
\seealso{
\code{interpolate.classes}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
