% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{pls}
\alias{pls}
\alias{pls.ER}
\title{Partial Least Squares modelling of ER objects.}
\usage{
pls(er, ...)

\method{pls}{ER}(
  er,
  effect,
  ncomp,
  newdata = NULL,
  er2,
  validation,
  jackknife = NULL,
  shave = NULL,
  df.used = NULL,
  ...
)
}
\arguments{
\item{er}{Object of class \code{ER}.}

\item{...}{Additional arguments for \code{plsr}.}

\item{effect}{The effect to be used as response.}

\item{ncomp}{Number of PLS components.}

\item{newdata}{Optional new data matrix for prediction.}

\item{er2}{Second object of class \code{ER} for comparison.}

\item{validation}{Optional validation parameters for \code{plsr}.}

\item{jackknife}{Optional argument specifying if jackknifing should be applied.}

\item{shave}{Optional argument indicating if variable shaving should be used. \code{shave} should be a list with two elements: the PLS filter method and the proportion to remove. \code{shave = TRUE} uses defaults: \code{list("sMC", 0.2)}.}

\item{df.used}{Optional argument indicating how many degrees of freedom have been consumed during deflation. Default value from input object.}
}
\description{
The output of \code{ER} is used as input to a PLS classification with the selected
effect as response. It is possible to compare two models using the \code{er2} argument. Variable
selection is available through Jackknifing (from package \code{pls}) and Shaving (from package \code{plsVarSel}).
}
\details{
If using the \code{shave} options, the segment type is given as \code{type} instead of \code{segment.type} (see examples).
}
\examples{
data(MS, package = "ER")
er <- ER(proteins ~ MS * cluster, data = MS[-1,])

# Simple PLS using interleaved cross-validation
plsMod <- pls(er, 'MS', 6, validation = "CV",
              segment.type = "interleaved", length.seg = 25)
scoreplot(plsMod, labels = "names")

# PLS with shaving of variables (mind different variable for cross-validation type)
plsModS <- pls(er, 'MS', 6, validation = "CV",
              type = "interleaved", length.seg=25, shave = TRUE)
# Error as a function of remaining variables
plot(plsModS$shave)
# Selected variables for minimum error
with(plsModS$shave, colnames(X)[variables[[min.red+1]]])

\donttest{ # Time consuming due to leave-one-out cross-validation
plsModJ <- pls(er, 'MS', 5, validation = "LOO",
              jackknife = TRUE)
colSums(plsModJ$classes == as.numeric(MS$MS[-1]))
# Jackknifed coefficient P-values (sorted)
plot(sort(plsModJ$jack[,1,1]), pch = '.', ylab = 'P-value')
abline(h=c(0.01,0.05),col=2:3)

scoreplot(plsModJ)
scoreplot(plsModJ, comps=c(1,3))   # Selected components
# Use MS categories for colouring and clusters for plot characters.
scoreplot(plsModJ, col = er$symbolicDesign[['MS']],
                  pch = 20+as.numeric(er$symbolicDesign[['cluster']]))
loadingplot(plsModJ, scatter=TRUE) # scatter=TRUE for scatter plot
}
}
\seealso{
\code{\link{ER}}, \code{\link{elastic}} and \code{\link{confints}}.
}
