% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectionClass.R
\docType{class}
\name{Selection-class}
\alias{Selection-class}
\title{\code{Selection} class}
\description{
Class used to generate objects that manage the selection in the simulations.
}
\details{
An object of type \code{Selection} is an object which describes the set of
fitnesses which will be taken into account in the simulations. The
selection according to these fitnesses can be applied at three levels:
at the level of the individual, at the level of the production of
gametes and at the level of the gametes themselves.
Selection is therefore genotypic in the first two cases (each genotype
is associated with a fitness value) and haplotypic in the third (each
haplotype is associated with a fitness value).
}
\section{Slots}{

\describe{
\item{\code{IDhaplotypes}}{IDs of haplotypes}

\item{\code{IDgenotypes}}{IDs of genotypes}

\item{\code{nbHaplo}}{the number of haplotypes}

\item{\code{nbGeno}}{the number of genotypes}

\item{\code{femgamFit}}{the vector of female's gamete fitness}

\item{\code{malegamFit}}{the vector of male's gamete fitness}

\item{\code{femindFit}}{the vector of female's individual fitness}

\item{\code{maleindFit}}{the vector of male's individual fitness}

\item{\code{indFit}}{the vector of individual fitness (in case of hermaphrodites)}

\item{\code{femProdFit}}{the vector of female's gamete production fitness}

\item{\code{maleProdFit}}{the vector of male's gamete production fitness}

\item{\code{sOnInds}}{a logical indicating whether a selection on individuals
has been configured by the user}

\item{\code{sOnGams}}{a logical indicating whether a selection on gametes
has been configured by the user}

\item{\code{sOnGamsProd}}{a logical indicating whether a selection on gamete
production has been configured by the user}
}}

\author{
Ehouarn Le Faou
}
