% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EaseClass.R
\name{simulate,Ease-method}
\alias{simulate,Ease-method}
\title{Simulate method for the \code{Ease} class}
\usage{
\S4method{simulate}{Ease}(
  object,
  nsim = 1,
  seed = NULL,
  includefreqGeno = TRUE,
  recording = FALSE,
  recordGenGap = 1,
  drift = TRUE,
  includeParams = TRUE,
  includeFitness = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{object}{a \code{Ease} object}

\item{nsim}{the number of simulation to perform}

\item{seed}{the probabilist seed to be fixed (allows exact reproduction of
results)}

\item{includefreqGeno}{a logical indicating whether to include genotype
frequencies in the results}

\item{recording}{a logical indicating whether to record all mutations, i.e.
to record allelic and genotypic frequencies along the simulations}

\item{recordGenGap}{the number of generations between two records during
simulation, if the record parameter is TRUE. Whatever the value of this
parameter, both the first and the last generation will be included in
the record}

\item{drift}{a logical indicating whether genetic drift should be
considered (i.e. whether deterministic simulations are performed or not)}

\item{includeParams}{a logical indicating whether the parameters should be
included in the result data.frame (can be useful when compiling multiple
result tables)}

\item{includeFitness}{a logical indicating whether the mean fitness should
be included in the result data.frame (can be useful when compiling multiple
result tables)}

\item{verbose}{logical determining if the progress of the simulations should
be displayed or not (useful in case of many simulations)}
}
\value{
An \code{Ease} object from which we can now extract the results
(or the records if recording = TRUE) with the getResults and getRecords
functions.
}
\description{
Performing simulations of an Ease object. The returned object is the same
Ease object completed with the results and records if they have been
activated.
}
\author{
Ehouarn Le Faou
}
