% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsembleFit-class.R
\docType{class}
\name{EnsembleFit-class}
\alias{EnsembleFit-class}
\title{A class to hold the samples or point estimates from the ensemble model.}
\description{
An \code{EnsembleFit} object is returned by the \code{fit_ensemble_model} function.
The object contains a slot for the \code{EnsembleData} object originally used to
fit the ensemble model. The \code{samples} slot contains the samples from the MCMC
if a full sampling was completed, otherwise the \code{point_estimate} slot contains
information about a point estimate.
}
\section{Slots}{

\describe{
\item{\code{ensemble_data}}{An \code{EnsembleData} object encapsulating the data used to fit the ensemble model.}

\item{\code{samples}}{A \code{stanfit} object containing the samples drawn from the fitted model. The default value is \code{NULL}.}

\item{\code{point_estimate}}{A \code{list} output of the optimised model. The default value is \code{NULL}.}
}}

\references{
Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.21.2. https://mc-stan.org
}
\seealso{
\code{\link{EnsembleFit}}, \code{\link{fit_ensemble_model}}, \code{\link{generate_sample}}
}
