% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.alfreq.R
\name{eco.alfreq}
\alias{eco.alfreq}
\title{Allelic frequency histogram for an ecogen genetic data frame}
\usage{
eco.alfreq(eco, fact = NULL)
}
\arguments{
\item{eco}{ecogen object}

\item{fact}{optional factor (column of S slot) for plotting by group.}
}
\description{
This program computes the frequency of each allele and plots
the number of alleles with a given frequency (as density). The distribution
is expected to be L-shaped under mutation-drift equilibrium.
When a factor is given, the program plots the distribution for each group.
}
\examples{
\dontrun{

data(eco.test)
eco.alfreq(eco)
eco.alfreq(eco, "structure")

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

