% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.remove.R
\name{eco.remove}
\alias{eco.remove}
\title{Creating an updated ecogen object by removing results of the slot OUT}
\usage{
eco.remove(eco, ...)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{...}{Objects to remove from eco, typed without quotations.}
}
\description{
Creating an updated ecogen object by removing results of the slot OUT
}
\examples{

\dontrun{

data(eco.test)
variog <- eco.variogram(eco[["P"]][, 1], eco[["XY"]])

# the assignment of values can be made with the corresponding accessors,
# using the generic notation of EcoGenetics 
# (<ecoslot.> + <name of the slot> + <name of the object>).
# See help("EcoGenetics accessors")

ecoslot.OUT(eco) <- variog         
we.are.numbers <- c(1:10)
we.are.characters <- c("John Coltrane", "Charlie Parker")
ecoslot.OUT(eco) <- list(we.are.numbers, we.are.characters)
ecoslot.OUT(eco)
eco <- eco.remove(eco, we.are.numbers)
ecoslot.OUT(eco)

}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
