% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.association.R
\name{eco.association}
\alias{eco.association}
\title{Chi-square and Fisher's exact test for association of loci and alleles 
with a factor}
\usage{
eco.association(
  eco,
  assoc = c("within", "between"),
  x,
  method = c("fisher.test", "chisq.test"),
  nrep = 99,
  adjust = "none",
  ndig = NA
)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{assoc}{"between" if the association test should be performed between
a factor and a loci, or "within" if the association test should be performed
between a factor and alleles within loci. For haploid data,
use option "within".}

\item{x}{The name of the S slot column with the groups for the association
test.}

\item{method}{Test method ("chisq.test" or "fisher.test").
Default is "fisher.test".}

\item{nrep}{Number of repetitions for the permutation test.}

\item{adjust}{Correction method of P-values for multiple tests, 
passed to \code{\link[stats]{p.adjust}}. Default is "none" (no correction).}

\item{ndig}{Number of digits coding each alleles 
(e.g. 2: xx, or 3: xxx) when assoc is "within".}
}
\description{
Chi-square and Fisher's exact test for association of loci and alleles 
with a factor
}
\examples{

\dontrun{

data(eco.test)
eco.association(eco, "within", "pop")
eco.association(eco, "within", "pop", adjust="fdr")
eco.association(eco, "within", "pop", method = "chisq.test")
eco.association(eco, "between", "pop", ndig = 1)
eco.association(eco, "between", "pop", method = "chisq.test", ndig = 1)

}

}
\seealso{
\code{\link[stats]{chisq.test}} \code{\link[stats]{fisher.test}}
\code{\link[stats]{fisher.test}}
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
