% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.mantel.R
\name{eco.mantel}
\alias{eco.mantel}
\title{Mantel and partial Mantel tests, with truncation option}
\usage{
eco.mantel(d1, d2, dc = NULL, con = NULL, thres = NULL,
  truncMat = c("d2", "d1", "dc"), method = c("pearson", "spearman",
  "kendall"), nsim = 99, alternative = c("auto", "two.sided", "less",
  "greater"), plotit = TRUE, ...)
}
\arguments{
\item{d1}{Distance matrix.}

\item{d2}{Distance matrix.}

\item{dc}{Distance matrix (optional).}

\item{con}{binary eco.weight object used for truncation or a weights object obtained with eco.bearing.}

\item{thres}{threshold distance used for truncation. distances above the threshold are
set as 4 times the threshold. If null, and con is not null, it is set to the maximum
distance observed in d2}

\item{truncMat}{Matrix to be used for truncation (default = d2)}

\item{method}{Correlation method used for the construction of the statistic 
("pearson", "spearman" or "kendall"). Kendall's tau computation is slow.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the alternative hypothesis.
Other options are: "two.sided", "greater" and "less".}

\item{plotit}{Should be generated a plot of the simulations?}

\item{...}{Additional arguments passed to \code{\link[stats]{cor}}.}
}
\value{
An object of class "eco.gsa" with the following slots:

> METHOD method used in the analysis

> OBS observed value

> EXP expect value

> PVAL P-value

> ALTER alternative hypotesis

> NSIM number of simulations


\strong{ACCESS TO THE SLOTS}
The content of the slots can be accessed 
with the corresponding accessors, using
the generic notation of EcoGenetics 
(<ecoslot.> + <name of the slot> + <name of the object>).
See help("EcoGenetics accessors") and the Examples
section below
}
\description{
This program computes the Mantel test between the distance matrices 
d1 and d2, or a partial Mantel test between the distance matrices. The test can 
be performed for truncated distances (Legendre et al. 2015) or with a direction
Falsetti and Sokal (1993) using a weights object generated with  \code{\link{eco.bearing}}.
d1 and d2, conditioned on dc.
}
\examples{

\dontrun{

data(eco.test)

eco.mantel(d1 = dist(eco[["P"]]), d2 = dist(eco[["E"]]), nsim = 99)   # ordinary Mantel test

pm <- eco.mantel(d1 = dist(eco[["P"]]), d2 = dist(eco[["E"]]), 
dc = dist(eco[["XY"]]), nsim = 99)                               # partial Mantel test

# checking threshold in a correlogram:
corm <- eco.cormantel(M = dist(eco[["P"]]), XY = eco[["XY"]], nsim = 99)
eco.plotCorrelog(corm)
Correlation is around 0 when distance between points is > 5

# create a weights object for truncation
con <- eco.weight(eco@XY, method="circle", d2=5)
#compute a truncated mantel test
eco.mantel(dist(eco[["P"]]), dist(eco[["XY"]]), con=con)

# analize test mantel in a direction of 35 degrees
con <- eco.bearing(XY = eco[["X"]], thata = 37)
eco.mantel(dist(eco[["P"]]), dist(eco[["XY"]]), con = con2)


#-----------------------
# ACCESSORS USE EXAMPLE
#-----------------------

# the slots are accessed with the generic format 
# (ecoslot. + name of the slot + name of the object). 
# See help("EcoGenetics accessors")

ecoslot.OBS(pm)     # slot OBS (observed value)
ecoslot.PVAL(pm)    # slot PVAL (P-value) 

}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\references{
Falsetti A., and Sokal R. 1993. Genetic structure of human populations
 in the British Isles. Annals of Human Biology 20: 215-229.

Legendre P. 2000. Comparison of permutation methods for the partial correlation
and partial Mantel tests. Journal of Statistical Computation and Simulation,
67: 37-73.

Legendre P., and M. Fortin. 2010. Comparison of the Mantel test and 
alternative approaches for detecting complex multivariate relationships 
in the spatial analysis of genetic data. Molecular Ecology Resources, 
10: 831-844.

Mantel N. 1967. The detection of disease clustering and a generalized 
regression approach. Cancer research, 27: 209-220.

Smouse P. Long and R. Sokal. 1986. Multiple regression and correlation 
extensions of the Mantel test of matrix correspondence. Systematic zoology, 627-632.
}

