% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{vector_sample}
\alias{vector_sample}
\title{Vector Sample Function}
\usage{
vector_sample(speciesData, weights)
}
\arguments{
\item{speciesData}{binary vector representing species presences and
absences.}

\item{weights}{a vector of non-negative read numbers representing
probabilistic weights for species occurrencs of the same length
as speciesData.}
}
\value{
Returns a re-ordered binary vector in which the occurrences
are placed in cells with probabilities proportional to values given
in weights.
}
\description{
Takes an input binary vector and a weight vector.
Reassigns 1s randomly in proportion to vector weights.
}
\details{
This function takes an input vector of binary presence-absence
values and a vector of non-negative probability weights. Both vectors
must be of identical length.
}
\note{
Several of the randomization algorithms use this function
to assign species occurrences with probabilities that reflect
species or site differences. It is an effective method for
conditioning the marginal probabilities of a null matrix on
independent measurements of site or species characteristics.
}
\examples{
myColonizer <- vector_sample(speciesData=rbinom(10,1,0.5),weights=runif(10))
}
\references{
Gotelli, N.J., G.R. Graves, and C. Rahbek. 2010. Macroecological
signals of species interactions in the Danish avifauna. Proceedings of the
National Academy of Sciences, U.S.A. 107: 530-535.
}
\seealso{
\code{\link{sim10}} randomization algorithm.
}

