% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Network_Ecotone.R
\name{NetworkEco}
\alias{NetworkEco}
\title{Networks for ecotones and communities}
\usage{
NetworkEco(ecotonefinder, threshold = 0.8, plot.type = c("percentage",
  "corrplot", "heatmap", "network"), method = c("cmeans", "vegclust"),
  dist.method = "inner_product", plot = c("species", "community"),
  order.sp = NULL, dist = c("count", "relative", "raw"),
  no.plot = FALSE, network.group = NULL, ...)
}
\arguments{
\item{ecotonefinder}{A list containing elements named in the same way than
EcotoneFinder function outcomes. Must contain cmeans results or vegclust
results.}

\item{threshold}{If count = T, the membership grade threshold used to sort
the species in the different clusters.}

\item{plot.type}{Which graphical representation to be plotted. Among
"percentage", "corrplot", "heatmap","network".}

\item{method}{The membership computation method to be used. One of "cmeans"
or "vegclust". Must be present in the ecotonefinder list.}

\item{dist.method}{Distance method for the computation of a distance matrix,
when dist = "raw" and dist = "relative".}

\item{plot}{If plot = "species", the distances are computed between the
species in the data. If plot = "community", the distances are computed
between the cluster centroids.}

\item{order.sp}{Vector providing the order in which to arrange the species.
If NULL, the column order will be kept.}

\item{dist}{The type of data on which distance calculations are made from. If
dist = "raw", the distance matrix is computed from the membership matrix
directly. if dist = "relative", the distance matrix is computed from the
relative memberships grades of each species in the clusters (between 0 and
1). If dist = "count", the species are assigned to clusters according to
the threshold and the distance matrix is computed from the number of common
species between the different clusters. See details.}

\item{no.plot}{Logical. Should the plot be displayed?. Set to TRUE to gain
computation time with large community matrix.}

\item{network.group}{Grouping parameter for the network. Can be user defined
(see qgraph documentation for details) but must be a factor of the same
lenght as the nodes of the graph.}

\item{...}{Additional arguments to be passed to the plotting functions, see
details.}
}
\value{
A list containing the percentage matrix, the distance matrix and the
  network object (depending of the arguments passed to the function)
}
\description{
Networks for ecotones and communities
}
\details{
The NetworkEco function provides wqys to explore the relations
  between fuzzy clusters. Several options are implemented. If dist = "raw",
  it computes a distance matrix from the membership grade matrix directly. If
  dist = "relative", the membership grades are standardized so that the sum
  of the membership grades of a given species equals to 1 for every points
  along the gradient (which corresponds to a percentage ot membership in each
  cluster). If dist = "count", the standardized membership grades of the are
  used to assign species in the community to a unique cluster and the number
  of common species between pairs of clusters is counted. The assignement of
  species to clusters is done by listing all the species that score a
  membership grade higher than the specified threshold in a cluster. The
  resulting list of species are then compared to one another.

  The function also allows the computation of distances between species
  rather than between clusters, when plot = "species". This can only be done
  from the memberships grades (raw or relative) and this argument will be
  disregarded if dist = "count".

  Several methods of visualisation are implemented: "percentage", "corrplot",
  "heatmap" and "network". If "percentage", a barplot (using ggplot2) of the
  standardized memberships grades per fuzzy cluster is plotted. It always
  plot the standardized membership grades regardless of the chosen dist
  option, but if dist = "count" or dist = "raw" are chosen, the function
  still compute the corresponding distance matrices and return them ti the
  output list. For time efficiency, it is not recommended to plot it when the
  number of species in the community is large (>100). "corrplot" and
  "heatmap" produce correlation matrix and heat map. The "network" is based
  on the qgraph function of the qgraph package. The ... argument may be used
  to pass additional arguments to the plotting functions (for graphical
  purposes).
}
\examples{
 #### Artificial dataset:
 SyntheticTrial <- SyntheticData(SpeciesNum = 21, CommunityNum = 3,
                                 SpCo = NULL, Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.015,3)),
                                 pal = c("#008585", "#FBF2C4", "#C7522B"))

 ## Analyses:
 SyntheticEcoFinder <- EcotoneFinder(data = SyntheticTrial[,-1],
                                     dist = SyntheticTrial$Distance,
                                     method = "all",
                                     groups = 3, standardize = "hellinger",
                                     diversity = "all")

 ## Percentage plot:
 SyntheticNetwork <- NetworkEco(SyntheticEcoFinder, threshold = .3, method = "cmeans",
                                plot.type = "percentage", dist = "count")

 ## Heatmap plot:
 SyntheticNetwork <- NetworkEco(SyntheticEcoFinder, plot.type = "heatmap",
                                method = "cmeans", dist = "raw", plot = "species")

 ## Network:
 # From raw membership grades:
 SyntheticNetwork <- NetworkEco(SyntheticEcoFinder, plot.type = "network",
                                method = "cmeans", dist = "raw", plot = "species")

 # From number of species per clusters:
 SyntheticNetwork <- NetworkEco(SyntheticEcoFinder, plot.type = "network", threshold = .3,
                                method = "cmeans", dist = "count", plot = "community",
                                layout = "spring")

}
