% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traj_elo.r
\name{traj_elo}
\alias{traj_elo}
\title{calculate dominance trajectory}
\usage{
traj_elo(eloobject, ID, from = min(eloobject$stability$date),
  to = max(eloobject$stability$date))
}
\arguments{
\item{eloobject}{result from \code{\link{elo.seq}}}

\item{ID}{character, the ID(s) of the individual(s)}

\item{from}{character, from which date onwards should the trajectory be calculated. By default the first date in the sequence is used}

\item{to}{character, until which date should the trajectory be calculated. By default the last date in the sequence is used}
}
\value{
A \code{data.frame} with as many lines as specified in \code{ID}, columns for ID, date range, the actual slope (trajectory), and the number of observed interactions within the date range
}
\description{
calculate individual Elo rating trajectory over time
}
\examples{
data(adv)
SEQ <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date)
traj_elo(SEQ, "a")

traj_elo(SEQ, "a", from = "2010-01-20", to = "2010-01-30")

# no slope available if ID was not observed interacting
# inside the date range
traj_elo(SEQ, "a", from = "2010-01-17", to = "2010-01-18")

# no slope available if ID was only observed interacting
# once within the date range
traj_elo(SEQ, "a", from = "2010-01-17", to = "2010-01-19")

# for several individuals
traj_elo(SEQ, c("a", "b", "c"))
}
\author{
Christof Neumann
}
