% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridinfo.R
\name{gridInfo}
\alias{gridInfo}
\title{Read grid information from a NetCDF file}
\usage{
gridInfo(
  file = file.choose(),
  z = FALSE,
  missing_time = "1984-03-10",
  verbose = TRUE
)
}
\arguments{
\item{file}{file name/path to a wrfinput, wrfchemi or geog_em file}

\item{z}{TRUE for read wrfinput vertical coordinades}

\item{missing_time}{time if the variable Times is missing}

\item{verbose}{display additional information}
}
\value{
a list with grid information from air quality model
}
\description{
Return a list containing information of a regular grid / domain
}
\note{
just WRF-Chem is suported by now
}
\examples{
grid_d1 <- gridInfo(paste(system.file("extdata", package = "EmissV"),
                                      "/wrfinput_d01",sep=""))
\donttest{grid_d2 <- gridInfo(paste(system.file("extdata", package = "EmissV"),
                                      "/wrfinput_d02",sep=""))
grid_d3 <- gridInfo(paste(system.file("extdata", package = "EmissV"),
                                      "/wrfinput_d03",sep=""))
names(grid_d1)
# for plot the shapes
shape   <- raster::shapefile(paste0(system.file("extdata", package = "EmissV"),
                                                "/BR.shp"))
raster::plot(shape,xlim = c(-55,-40),ylim = c(-30,-15), main="3 nested domains")
axis(1); axis(2); box(); grid()
lines(grid_d1$boundary, col = "red")
text(grid_d1$xlim[2],grid_d1$Ylim[1],"d1",pos=4, offset = 0.5)
lines(grid_d2$boundary, col = "red")
text(grid_d2$xlim[2],grid_d2$Ylim[1],"d2",pos=4, offset = 0.5)
lines(grid_d3$boundary, col = "red")
text(grid_d3$xlim[1],grid_d3$Ylim[2],"d3",pos=2, offset = 0.0)
}
}
