% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{regional_summary}
\alias{regional_summary}
\title{Generate Regional Summary Output}
\usage{
regional_summary(
  regional_output,
  reported_cases,
  results_dir,
  summary_dir,
  target_date,
  region_scale = "Region",
  all_regions = TRUE,
  return_summary = TRUE,
  max_plot = 10
)
}
\arguments{
\item{regional_output}{A list of output as produced by \code{regional_epinow} and stored in the
\code{regional} list.}

\item{reported_cases}{A data frame of confirmed cases (confirm) by date (date), and region (\code{region}).}

\item{results_dir}{An optional character string indicating the location of the results directory to extract results
from.}

\item{summary_dir}{A character string giving the directory
in which to store summary of results.}

\item{target_date}{A character string giving the target date for which to extract results
(in the format "yyyy-mm-dd"). Defaults to latest available estimates.}

\item{region_scale}{A character string indicating the name to give the regions being summarised.}

\item{all_regions}{Logical, defaults to \code{TRUE}. Should summary plots for all regions be returned
rather than just regions of interest.}

\item{return_summary}{Logical, defaults to \code{TRUE}. Should summary measures be returned.}

\item{max_plot}{Numeric, defaults to 10. A multiplicative upper bound on the number of cases shown on the plot. Based
on the maximum number of reported cases.}
}
\value{
A list of summary measures and plots
}
\description{
Generate Regional Summary Output
}
\examples{
\donttest{
# Construct example distributions
generation_time <- list(mean = EpiNow2::covid_generation_times[1, ]$mean,
                        mean_sd = EpiNow2::covid_generation_times[1, ]$mean_sd,
                        sd = EpiNow2::covid_generation_times[1, ]$sd,
                        sd_sd = EpiNow2::covid_generation_times[1, ]$sd_sd,
                        max = 30)
                          
incubation_period <- list(mean = EpiNow2::covid_incubation_period[1, ]$mean,
                          mean_sd = EpiNow2::covid_incubation_period[1, ]$mean_sd,
                          sd = EpiNow2::covid_incubation_period[1, ]$sd,
                          sd_sd = EpiNow2::covid_incubation_period[1, ]$sd_sd,
                          max = 30)
                   
reporting_delay <- list(mean = log(10),
                        mean_sd = 0.8,
                        sd = log(2),
                        sd_sd = 0.1,
                        max = 30)
                        
# Uses example case vector from EpiSoon
cases <- EpiNow2::example_confirmed[1:30]

cases <- data.table::rbindlist(list(
  data.table::copy(cases)[, region := "testland"],
  cases[, region := "realland"]))
  
# Run basic nowcasting pipeline
regional_out <- regional_epinow(reported_cases = cases,
                                generation_time = generation_time,
                                delays = list(incubation_period, reporting_delay),
                                samples = 2000, warmup = 200, cores = 4,
                                adapt_delta = 0.95, chains = 4, verbose = TRUE,
                                summary = FALSE)

results_dir <- tempdir()             

regional_summary(regional_output = regional_out$regional,
                 reported_cases = cases,
                 summary_dir = results_dir,
                 region_scale = "Country", all_regions = FALSE)

} 

}
