% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{+.dist_spec}
\alias{+.dist_spec}
\title{Creates a delay distribution as the sum of two other delay distributions}
\usage{
\method{+}{dist_spec}(e1, e2)
}
\arguments{
\item{e1}{The first delay distribution (from a call to \code{\link[=dist_spec]{dist_spec()}}) to
combine.}

\item{e2}{The second delay distribution (from a call to \code{\link[=dist_spec]{dist_spec()}}) to
combine.}
}
\value{
A delay distribution representing the sum of the two delays
(with class \code{\link[=dist_spec]{dist_spec()}})
}
\description{
This is done via convolution with \code{stats::convolve()}. Nonparametric delays
that can be combined are processed together, and their cumulative
distribution function is truncated at a specified tolerance level, ensuring
numeric stability.
}
\examples{
# A fixed lognormal distribution with mean 5 and sd 1.
lognormal <- dist_spec(
  mean = 1.6, sd = 1, max = 20, distribution = "lognormal"
)
lognormal + lognormal

# An uncertain gamma distribution with mean 3 and sd 2
gamma <- dist_spec(
  mean = 3, sd = 2, mean_sd = 0.5, sd_sd = 0.5, max = 20,
  distribution = "gamma"
)
lognormal + gamma

# Using tolerance parameter
EpiNow2:::dist_spec_plus(lognormal, lognormal, tolerance = 0.5)
}
\author{
Sebastian Funk
}
