// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_estimate_truncation_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'estimate_truncation', line 370, column 2 to column 35)",
                                                      " (in 'estimate_truncation', line 371, column 2 to column 44)",
                                                      " (in 'estimate_truncation', line 372, column 2 to column 20)",
                                                      " (in 'estimate_truncation', line 373, column 2 to column 22)",
                                                      " (in 'estimate_truncation', line 376, column 2 to column 32)",
                                                      " (in 'estimate_truncation', line 377, column 2 to line 379, column 4)",
                                                      " (in 'estimate_truncation', line 380, column 2 to line 385, column 4)",
                                                      " (in 'estimate_truncation', line 387, column 9 to column 10)",
                                                      " (in 'estimate_truncation', line 387, column 2 to column 21)",
                                                      " (in 'estimate_truncation', line 389, column 2 to column 68)",
                                                      " (in 'estimate_truncation', line 393, column 4 to line 394, column 72)",
                                                      " (in 'estimate_truncation', line 392, column 30 to line 395, column 4)",
                                                      " (in 'estimate_truncation', line 392, column 2 to line 395, column 4)",
                                                      " (in 'estimate_truncation', line 386, column 2 to line 396, column 3)",
                                                      " (in 'estimate_truncation', line 416, column 2 to line 418, column 4)",
                                                      " (in 'estimate_truncation', line 419, column 2 to column 57)",
                                                      " (in 'estimate_truncation', line 422, column 4 to line 424, column 6)",
                                                      " (in 'estimate_truncation', line 421, column 24 to line 425, column 3)",
                                                      " (in 'estimate_truncation', line 421, column 2 to line 425, column 3)",
                                                      " (in 'estimate_truncation', line 432, column 8 to column 70)",
                                                      " (in 'estimate_truncation', line 431, column 13 to line 433, column 7)",
                                                      " (in 'estimate_truncation', line 430, column 8 to column 26)",
                                                      " (in 'estimate_truncation', line 429, column 32 to line 431, column 7)",
                                                      " (in 'estimate_truncation', line 429, column 6 to line 433, column 7)",
                                                      " (in 'estimate_truncation', line 428, column 42 to line 434, column 5)",
                                                      " (in 'estimate_truncation', line 428, column 4 to line 434, column 5)",
                                                      " (in 'estimate_truncation', line 427, column 30 to line 435, column 3)",
                                                      " (in 'estimate_truncation', line 427, column 2 to line 435, column 3)",
                                                      " (in 'estimate_truncation', line 400, column 2 to line 403, column 4)",
                                                      " (in 'estimate_truncation', line 405, column 23 to column 24)",
                                                      " (in 'estimate_truncation', line 405, column 2 to column 27)",
                                                      " (in 'estimate_truncation', line 406, column 25 to column 26)",
                                                      " (in 'estimate_truncation', line 406, column 2 to column 29)",
                                                      " (in 'estimate_truncation', line 411, column 6 to column 77)",
                                                      " (in 'estimate_truncation', line 410, column 45 to line 412, column 5)",
                                                      " (in 'estimate_truncation', line 410, column 4 to line 412, column 5)",
                                                      " (in 'estimate_truncation', line 409, column 30 to line 413, column 3)",
                                                      " (in 'estimate_truncation', line 409, column 2 to line 413, column 3)",
                                                      " (in 'estimate_truncation', line 331, column 2 to column 8)",
                                                      " (in 'estimate_truncation', line 332, column 2 to column 15)",
                                                      " (in 'estimate_truncation', line 333, column 8 to column 9)",
                                                      " (in 'estimate_truncation', line 333, column 11 to column 19)",
                                                      " (in 'estimate_truncation', line 333, column 2 to column 29)",
                                                      " (in 'estimate_truncation', line 334, column 8 to column 16)",
                                                      " (in 'estimate_truncation', line 334, column 2 to column 31)",
                                                      " (in 'estimate_truncation', line 336, column 2 to column 25)",
                                                      " (in 'estimate_truncation', line 337, column 2 to column 27)",
                                                      " (in 'estimate_truncation', line 338, column 2 to column 28)",
                                                      " (in 'estimate_truncation', line 339, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 339, column 2 to column 40)",
                                                      " (in 'estimate_truncation', line 340, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 340, column 2 to column 49)",
                                                      " (in 'estimate_truncation', line 341, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 341, column 2 to column 49)",
                                                      " (in 'estimate_truncation', line 342, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 342, column 2 to column 47)",
                                                      " (in 'estimate_truncation', line 343, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 343, column 2 to column 44)",
                                                      " (in 'estimate_truncation', line 344, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 344, column 2 to column 45)",
                                                      " (in 'estimate_truncation', line 345, column 2 to column 34)",
                                                      " (in 'estimate_truncation', line 346, column 31 to column 47)",
                                                      " (in 'estimate_truncation', line 346, column 2 to column 62)",
                                                      " (in 'estimate_truncation', line 347, column 8 to column 22)",
                                                      " (in 'estimate_truncation', line 347, column 2 to column 59)",
                                                      " (in 'estimate_truncation', line 348, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 348, column 2 to column 47)",
                                                      " (in 'estimate_truncation', line 350, column 2 to column 29)",
                                                      " (in 'estimate_truncation', line 351, column 8 to column 15)",
                                                      " (in 'estimate_truncation', line 351, column 2 to column 46)",
                                                      " (in 'estimate_truncation', line 352, column 8 to column 15)",
                                                      " (in 'estimate_truncation', line 352, column 2 to column 47)",
                                                      " (in 'estimate_truncation', line 353, column 8 to column 23)",
                                                      " (in 'estimate_truncation', line 353, column 2 to column 59)",
                                                      " (in 'estimate_truncation', line 356, column 2 to column 19)",
                                                      " (in 'estimate_truncation', line 357, column 8 to column 16)",
                                                      " (in 'estimate_truncation', line 357, column 2 to column 39)",
                                                      " (in 'estimate_truncation', line 358, column 8 to column 16)",
                                                      " (in 'estimate_truncation', line 358, column 2 to column 41)",
                                                      " (in 'estimate_truncation', line 359, column 8 to column 19)",
                                                      " (in 'estimate_truncation', line 359, column 2 to column 40)",
                                                      " (in 'estimate_truncation', line 360, column 2 to line 363, column 4)",
                                                      " (in 'estimate_truncation', line 365, column 4 to column 31)",
                                                      " (in 'estimate_truncation', line 366, column 4 to column 65)",
                                                      " (in 'estimate_truncation', line 364, column 24 to line 367, column 3)",
                                                      " (in 'estimate_truncation', line 364, column 2 to line 367, column 3)",
                                                      " (in 'estimate_truncation', line 370, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 371, column 8 to column 17)",
                                                      " (in 'estimate_truncation', line 377, column 9 to column 33)",
                                                      " (in 'estimate_truncation', line 377, column 35 to column 47)",
                                                      " (in 'estimate_truncation', line 380, column 9 to column 33)",
                                                      " (in 'estimate_truncation', line 416, column 9 to column 33)",
                                                      " (in 'estimate_truncation', line 416, column 35 to column 43)",
                                                      " (in 'estimate_truncation', line 419, column 9 to column 33)",
                                                      " (in 'estimate_truncation', line 419, column 35 to column 47)",
                                                      " (in 'estimate_truncation', line 7, column 4 to column 31)",
                                                      " (in 'estimate_truncation', line 8, column 4 to column 31)",
                                                      " (in 'estimate_truncation', line 9, column 11 to column 14)",
                                                      " (in 'estimate_truncation', line 9, column 4 to column 18)",
                                                      " (in 'estimate_truncation', line 11, column 6 to column 75)",
                                                      " (in 'estimate_truncation', line 10, column 28 to line 12, column 5)",
                                                      " (in 'estimate_truncation', line 10, column 4 to line 12, column 5)",
                                                      " (in 'estimate_truncation', line 14, column 6 to line 17, column 8)",
                                                      " (in 'estimate_truncation', line 13, column 21 to line 18, column 5)",
                                                      " (in 'estimate_truncation', line 13, column 4 to line 18, column 5)",
                                                      " (in 'estimate_truncation', line 19, column 3 to column 13)",
                                                      " (in 'estimate_truncation', line 6, column 58 to line 20, column 3)",
                                                      " (in 'estimate_truncation', line 27, column 2 to column 35)",
                                                      " (in 'estimate_truncation', line 28, column 9 to column 25)",
                                                      " (in 'estimate_truncation', line 28, column 2 to column 35)",
                                                      " (in 'estimate_truncation', line 29, column 9 to column 10)",
                                                      " (in 'estimate_truncation', line 29, column 2 to column 39)",
                                                      " (in 'estimate_truncation', line 30, column 2 to column 43)",
                                                      " (in 'estimate_truncation', line 35, column 4 to column 47)",
                                                      " (in 'estimate_truncation', line 34, column 9 to line 36, column 3)",
                                                      " (in 'estimate_truncation', line 32, column 4 to column 75)",
                                                      " (in 'estimate_truncation', line 33, column 4 to column 50)",
                                                      " (in 'estimate_truncation', line 31, column 14 to line 34, column 3)",
                                                      " (in 'estimate_truncation', line 31, column 2 to line 36, column 3)",
                                                      " (in 'estimate_truncation', line 37, column 2 to column 18)",
                                                      " (in 'estimate_truncation', line 26, column 44 to line 38, column 1)",
                                                      " (in 'estimate_truncation', line 47, column 9 to column 10)",
                                                      " (in 'estimate_truncation', line 47, column 2 to column 17)",
                                                      " (in 'estimate_truncation', line 70, column 4 to column 46)",
                                                      " (in 'estimate_truncation', line 71, column 4 to column 16)",
                                                      " (in 'estimate_truncation', line 68, column 9 to line 72, column 3)",
                                                      " (in 'estimate_truncation', line 49, column 11 to column 12)",
                                                      " (in 'estimate_truncation', line 49, column 4 to column 25)",
                                                      " (in 'estimate_truncation', line 61, column 6 to column 56)",
                                                      " (in 'estimate_truncation', line 60, column 11 to line 62, column 5)",
                                                      " (in 'estimate_truncation', line 55, column 6 to column 34)",
                                                      " (in 'estimate_truncation', line 56, column 6 to column 31)",
                                                      " (in 'estimate_truncation', line 58, column 8 to column 52)",
                                                      " (in 'estimate_truncation', line 57, column 21 to line 59, column 7)",
                                                      " (in 'estimate_truncation', line 57, column 6 to line 59, column 7)",
                                                      " (in 'estimate_truncation', line 54, column 26 to line 60, column 5)",
                                                      " (in 'estimate_truncation', line 54, column 11 to line 62, column 5)",
                                                      " (in 'estimate_truncation', line 52, column 8 to column 54)",
                                                      " (in 'estimate_truncation', line 51, column 21 to line 53, column 7)",
                                                      " (in 'estimate_truncation', line 51, column 6 to line 53, column 7)",
                                                      " (in 'estimate_truncation', line 50, column 19 to line 54, column 5)",
                                                      " (in 'estimate_truncation', line 50, column 4 to line 62, column 5)",
                                                      " (in 'estimate_truncation', line 64, column 4 to column 28)",
                                                      " (in 'estimate_truncation', line 65, column 4 to column 67)",
                                                      " (in 'estimate_truncation', line 67, column 4 to column 32)",
                                                      " (in 'estimate_truncation', line 48, column 17 to line 68, column 3)",
                                                      " (in 'estimate_truncation', line 48, column 2 to line 72, column 3)",
                                                      " (in 'estimate_truncation', line 73, column 2 to column 20)",
                                                      " (in 'estimate_truncation', line 46, column 61 to line 74, column 1)",
                                                      " (in 'estimate_truncation', line 78, column 2 to column 34)",
                                                      " (in 'estimate_truncation', line 79, column 9 to column 16)",
                                                      " (in 'estimate_truncation', line 79, column 2 to column 26)",
                                                      " (in 'estimate_truncation', line 81, column 4 to column 38)",
                                                      " (in 'estimate_truncation', line 80, column 23 to line 82, column 3)",
                                                      " (in 'estimate_truncation', line 80, column 2 to line 82, column 3)",
                                                      " (in 'estimate_truncation', line 83, column 2 to column 17)",
                                                      " (in 'estimate_truncation', line 77, column 30 to line 84, column 1)",
                                                      " (in 'estimate_truncation', line 87, column 9 to column 12)",
                                                      " (in 'estimate_truncation', line 87, column 2 to column 18)",
                                                      " (in 'estimate_truncation', line 89, column 4 to column 28)",
                                                      " (in 'estimate_truncation', line 88, column 19 to line 90, column 3)",
                                                      " (in 'estimate_truncation', line 88, column 2 to line 90, column 3)",
                                                      " (in 'estimate_truncation', line 91, column 2 to column 14)",
                                                      " (in 'estimate_truncation', line 86, column 34 to line 92, column 1)",
                                                      " (in 'estimate_truncation', line 95, column 2 to column 34)",
                                                      " (in 'estimate_truncation', line 96, column 9 to column 12)",
                                                      " (in 'estimate_truncation', line 96, column 2 to column 47)",
                                                      " (in 'estimate_truncation', line 97, column 2 to column 44)",
                                                      " (in 'estimate_truncation', line 94, column 44 to line 98, column 1)",
                                                      " (in 'estimate_truncation', line 101, column 2 to column 34)",
                                                      " (in 'estimate_truncation', line 102, column 9 to column 12)",
                                                      " (in 'estimate_truncation', line 102, column 2 to column 47)",
                                                      " (in 'estimate_truncation', line 104, column 4 to column 44)",
                                                      " (in 'estimate_truncation', line 103, column 19 to line 105, column 3)",
                                                      " (in 'estimate_truncation', line 103, column 2 to line 105, column 3)",
                                                      " (in 'estimate_truncation', line 106, column 2 to column 59)",
                                                      " (in 'estimate_truncation', line 100, column 54 to line 107, column 1)",
                                                      " (in 'estimate_truncation', line 111, column 2 to column 32)",
                                                      " (in 'estimate_truncation', line 112, column 2 to column 32)",
                                                      " (in 'estimate_truncation', line 114, column 9 to column 11)",
                                                      " (in 'estimate_truncation', line 114, column 2 to column 41)",
                                                      " (in 'estimate_truncation', line 115, column 9 to column 10)",
                                                      " (in 'estimate_truncation', line 115, column 2 to column 27)",
                                                      " (in 'estimate_truncation', line 118, column 4 to column 67)",
                                                      " (in 'estimate_truncation', line 116, column 17 to line 119, column 4)",
                                                      " (in 'estimate_truncation', line 116, column 2 to line 119, column 4)",
                                                      " (in 'estimate_truncation', line 120, column 2 to column 25)",
                                                      " (in 'estimate_truncation', line 110, column 82 to line 121, column 1)",
                                                      " (in 'estimate_truncation', line 125, column 2 to column 32)",
                                                      " (in 'estimate_truncation', line 126, column 9 to column 10)",
                                                      " (in 'estimate_truncation', line 126, column 2 to column 27)",
                                                      " (in 'estimate_truncation', line 127, column 2 to column 38)",
                                                      " (in 'estimate_truncation', line 128, column 2 to column 25)",
                                                      " (in 'estimate_truncation', line 124, column 48 to line 129, column 1)",
                                                      " (in 'estimate_truncation', line 132, column 2 to column 32)",
                                                      " (in 'estimate_truncation', line 133, column 9 to column 10)",
                                                      " (in 'estimate_truncation', line 133, column 2 to column 36)",
                                                      " (in 'estimate_truncation', line 135, column 2 to column 54)",
                                                      " (in 'estimate_truncation', line 136, column 2 to column 34)",
                                                      " (in 'estimate_truncation', line 141, column 4 to column 60)",
                                                      " (in 'estimate_truncation', line 140, column 9 to line 142, column 3)",
                                                      " (in 'estimate_truncation', line 139, column 4 to column 60)",
                                                      " (in 'estimate_truncation', line 138, column 19 to line 140, column 3)",
                                                      " (in 'estimate_truncation', line 138, column 2 to line 142, column 3)",
                                                      " (in 'estimate_truncation', line 143, column 2 to column 24)",
                                                      " (in 'estimate_truncation', line 131, column 71 to line 144, column 1)",
                                                      " (in 'estimate_truncation', line 149, column 2 to column 49)",
                                                      " (in 'estimate_truncation', line 153, column 6 to column 63)",
                                                      " (in 'estimate_truncation', line 151, column 30 to line 154, column 5)",
                                                      " (in 'estimate_truncation', line 151, column 4 to line 154, column 5)",
                                                      " (in 'estimate_truncation', line 157, column 6 to column 57)",
                                                      " (in 'estimate_truncation', line 155, column 28 to line 158, column 5)",
                                                      " (in 'estimate_truncation', line 155, column 4 to line 158, column 5)",
                                                      " (in 'estimate_truncation', line 150, column 18 to line 159, column 3)",
                                                      " (in 'estimate_truncation', line 150, column 2 to line 159, column 3)",
                                                      " (in 'estimate_truncation', line 148, column 73 to line 160, column 1)",
                                                      " (in 'estimate_truncation', line 178, column 6 to column 55)",
                                                      " (in 'estimate_truncation', line 177, column 11 to line 179, column 5)",
                                                      " (in 'estimate_truncation', line 176, column 6 to column 31)",
                                                      " (in 'estimate_truncation', line 175, column 21 to line 177, column 5)",
                                                      " (in 'estimate_truncation', line 175, column 4 to line 179, column 5)",
                                                      " (in 'estimate_truncation', line 174, column 9 to line 180, column 3)",
                                                      " (in 'estimate_truncation', line 166, column 4 to column 18)",
                                                      " (in 'estimate_truncation', line 167, column 53 to column 54)",
                                                      " (in 'estimate_truncation', line 167, column 4 to column 57)",
                                                      " (in 'estimate_truncation', line 168, column 4 to column 45)",
                                                      " (in 'estimate_truncation', line 172, column 6 to column 72)",
                                                      " (in 'estimate_truncation', line 171, column 11 to line 173, column 5)",
                                                      " (in 'estimate_truncation', line 170, column 6 to column 48)",
                                                      " (in 'estimate_truncation', line 169, column 21 to line 171, column 5)",
                                                      " (in 'estimate_truncation', line 169, column 4 to line 173, column 5)",
                                                      " (in 'estimate_truncation', line 165, column 18 to line 174, column 3)",
                                                      " (in 'estimate_truncation', line 165, column 2 to line 180, column 3)",
                                                      " (in 'estimate_truncation', line 164, column 44 to line 181, column 1)",
                                                      " (in 'estimate_truncation', line 185, column 2 to column 32)",
                                                      " (in 'estimate_truncation', line 186, column 9 to column 10)",
                                                      " (in 'estimate_truncation', line 186, column 2 to column 20)",
                                                      " (in 'estimate_truncation', line 194, column 4 to column 50)",
                                                      " (in 'estimate_truncation', line 196, column 6 to column 81)",
                                                      " (in 'estimate_truncation', line 195, column 19 to line 197, column 5)",
                                                      " (in 'estimate_truncation', line 195, column 4 to line 197, column 5)",
                                                      " (in 'estimate_truncation', line 193, column 9 to line 198, column 3)",
                                                      " (in 'estimate_truncation', line 191, column 6 to column 64)",
                                                      " (in 'estimate_truncation', line 190, column 19 to line 192, column 5)",
                                                      " (in 'estimate_truncation', line 190, column 4 to line 192, column 5)",
                                                      " (in 'estimate_truncation', line 189, column 23 to line 193, column 3)",
                                                      " (in 'estimate_truncation', line 189, column 2 to line 198, column 3)",
                                                      " (in 'estimate_truncation', line 199, column 2 to column 18)",
                                                      " (in 'estimate_truncation', line 184, column 73 to line 200, column 1)",
                                                      " (in 'estimate_truncation', line 203, column 2 to column 32)",
                                                      " (in 'estimate_truncation', line 204, column 8 to column 9)",
                                                      " (in 'estimate_truncation', line 204, column 2 to column 31)",
                                                      " (in 'estimate_truncation', line 205, column 2 to column 22)",
                                                      " (in 'estimate_truncation', line 207, column 4 to column 45)",
                                                      " (in 'estimate_truncation', line 206, column 18 to line 208, column 3)",
                                                      " (in 'estimate_truncation', line 206, column 2 to line 208, column 3)",
                                                      " (in 'estimate_truncation', line 218, column 8 to column 95)",
                                                      " (in 'estimate_truncation', line 217, column 13 to line 219, column 7)",
                                                      " (in 'estimate_truncation', line 216, column 8 to column 78)",
                                                      " (in 'estimate_truncation', line 215, column 26 to line 217, column 7)",
                                                      " (in 'estimate_truncation', line 215, column 6 to line 219, column 7)",
                                                      " (in 'estimate_truncation', line 213, column 11 to line 220, column 5)",
                                                      " (in 'estimate_truncation', line 212, column 6 to column 29)",
                                                      " (in 'estimate_truncation', line 211, column 27 to line 213, column 5)",
                                                      " (in 'estimate_truncation', line 211, column 4 to line 220, column 5)",
                                                      " (in 'estimate_truncation', line 210, column 17 to line 221, column 3)",
                                                      " (in 'estimate_truncation', line 210, column 2 to line 221, column 3)",
                                                      " (in 'estimate_truncation', line 222, column 2 to column 26)",
                                                      " (in 'estimate_truncation', line 202, column 77 to line 223, column 1)",
                                                      " (in 'estimate_truncation', line 229, column 8 to column 19)",
                                                      " (in 'estimate_truncation', line 229, column 2 to column 29)",
                                                      " (in 'estimate_truncation', line 231, column 4 to column 15)",
                                                      " (in 'estimate_truncation', line 236, column 8 to line 237, column 53)",
                                                      " (in 'estimate_truncation', line 235, column 13 to line 238, column 7)",
                                                      " (in 'estimate_truncation', line 234, column 8 to column 51)",
                                                      " (in 'estimate_truncation', line 233, column 28 to line 235, column 7)",
                                                      " (in 'estimate_truncation', line 233, column 6 to line 238, column 7)",
                                                      " (in 'estimate_truncation', line 232, column 69 to line 239, column 5)",
                                                      " (in 'estimate_truncation', line 232, column 4 to line 239, column 5)",
                                                      " (in 'estimate_truncation', line 230, column 27 to line 240, column 3)",
                                                      " (in 'estimate_truncation', line 230, column 2 to line 240, column 3)",
                                                      " (in 'estimate_truncation', line 241, column 2 to column 13)",
                                                      " (in 'estimate_truncation', line 228, column 2 to line 242, column 1)",
                                                      " (in 'estimate_truncation', line 252, column 9 to column 12)",
                                                      " (in 'estimate_truncation', line 252, column 2 to column 39)",
                                                      " (in 'estimate_truncation', line 253, column 2 to column 22)",
                                                      " (in 'estimate_truncation', line 254, column 2 to column 14)",
                                                      " (in 'estimate_truncation', line 273, column 6 to column 57)",
                                                      " (in 'estimate_truncation', line 274, column 6 to column 63)",
                                                      " (in 'estimate_truncation', line 275, column 6 to column 42)",
                                                      " (in 'estimate_truncation', line 279, column 8 to line 281, column 10)",
                                                      " (in 'estimate_truncation', line 278, column 13 to line 282, column 7)",
                                                      " (in 'estimate_truncation', line 277, column 8 to column 49)",
                                                      " (in 'estimate_truncation', line 276, column 28 to line 278, column 7)",
                                                      " (in 'estimate_truncation', line 276, column 6 to line 282, column 7)",
                                                      " (in 'estimate_truncation', line 272, column 11 to line 283, column 5)",
                                                      " (in 'estimate_truncation', line 257, column 13 to column 41)",
                                                      " (in 'estimate_truncation', line 257, column 6 to line 263, column 8)",
                                                      " (in 'estimate_truncation', line 264, column 6 to column 63)",
                                                      " (in 'estimate_truncation', line 268, column 8 to line 270, column 10)",
                                                      " (in 'estimate_truncation', line 267, column 13 to line 271, column 7)",
                                                      " (in 'estimate_truncation', line 266, column 8 to column 42)",
                                                      " (in 'estimate_truncation', line 265, column 28 to line 267, column 7)",
                                                      " (in 'estimate_truncation', line 265, column 6 to line 271, column 7)",
                                                      " (in 'estimate_truncation', line 256, column 26 to line 272, column 5)",
                                                      " (in 'estimate_truncation', line 256, column 4 to line 283, column 5)",
                                                      " (in 'estimate_truncation', line 284, column 4 to column 26)",
                                                      " (in 'estimate_truncation', line 255, column 81 to line 285, column 3)",
                                                      " (in 'estimate_truncation', line 255, column 2 to line 285, column 3)",
                                                      " (in 'estimate_truncation', line 287, column 4 to line 290, column 6)",
                                                      " (in 'estimate_truncation', line 286, column 21 to line 291, column 3)",
                                                      " (in 'estimate_truncation', line 286, column 2 to line 291, column 3)",
                                                      " (in 'estimate_truncation', line 293, column 4 to column 30)",
                                                      " (in 'estimate_truncation', line 292, column 18 to line 294, column 3)",
                                                      " (in 'estimate_truncation', line 292, column 2 to line 294, column 3)",
                                                      " (in 'estimate_truncation', line 296, column 4 to column 26)",
                                                      " (in 'estimate_truncation', line 295, column 19 to line 297, column 3)",
                                                      " (in 'estimate_truncation', line 295, column 2 to line 297, column 3)",
                                                      " (in 'estimate_truncation', line 298, column 2 to column 13)",
                                                      " (in 'estimate_truncation', line 250, column 2 to line 299, column 1)",
                                                      " (in 'estimate_truncation', line 305, column 4 to column 47)",
                                                      " (in 'estimate_truncation', line 306, column 4 to column 43)",
                                                      " (in 'estimate_truncation', line 311, column 10 to column 98)",
                                                      " (in 'estimate_truncation', line 314, column 12 to column 90)",
                                                      " (in 'estimate_truncation', line 313, column 29 to line 315, column 11)",
                                                      " (in 'estimate_truncation', line 313, column 10 to line 315, column 11)",
                                                      " (in 'estimate_truncation', line 309, column 34 to line 316, column 9)",
                                                      " (in 'estimate_truncation', line 309, column 8 to line 316, column 9)",
                                                      " (in 'estimate_truncation', line 308, column 31 to line 317, column 7)",
                                                      " (in 'estimate_truncation', line 308, column 6 to line 317, column 7)",
                                                      " (in 'estimate_truncation', line 307, column 21 to line 318, column 5)",
                                                      " (in 'estimate_truncation', line 307, column 4 to line 318, column 5)",
                                                      " (in 'estimate_truncation', line 323, column 10 to column 92)",
                                                      " (in 'estimate_truncation', line 324, column 10 to column 84)",
                                                      " (in 'estimate_truncation', line 321, column 32 to line 325, column 9)",
                                                      " (in 'estimate_truncation', line 321, column 8 to line 325, column 9)",
                                                      " (in 'estimate_truncation', line 320, column 29 to line 326, column 6)",
                                                      " (in 'estimate_truncation', line 320, column 6 to line 326, column 6)",
                                                      " (in 'estimate_truncation', line 319, column 19 to line 327, column 3)",
                                                      " (in 'estimate_truncation', line 319, column 4 to line 327, column 3)",
                                                      " (in 'estimate_truncation', line 304, column 59 to line 328, column 1)"};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
convolve_with_rev_pmf(const T0__& x_arg__, const T1__& y_arg__,
                      const int& len, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& x = to_ref(x_arg__);
  const auto& y = to_ref(y_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int xlen;
    xlen = std::numeric_limits<int>::min();
    
    current_statement__ = 96;
    xlen = num_elements(x);
    int ylen;
    ylen = std::numeric_limits<int>::min();
    
    current_statement__ = 97;
    ylen = num_elements(y);
    current_statement__ = 98;
    validate_non_negative_index("z", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> z;
    z = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(z, DUMMY_VAR__);
    
    current_statement__ = 102;
    if (logical_lte((xlen + ylen), len)) {
      current_statement__ = 100;
      std::stringstream errmsg_stream__;
      errmsg_stream__ << "convolve_with_rev_pmf: len is longer then x and y combined";
      throw std::domain_error(errmsg_stream__.str());
    } 
    current_statement__ = 105;
    for (int s = 1; s <= len; ++s) {
      current_statement__ = 103;
      assign(z, cons_list(index_uni(s), nil_index_list()),
        dot_product(
          rvalue(x,
            cons_list(
              index_min_max(std::max(1, ((s - ylen) + 1)), std::min(s, xlen)),
              nil_index_list()), "x"),
          rvalue(y,
            cons_list(
              index_min_max(std::max(1, ((ylen - s) + 1)), std::min(ylen,
                                                             ((ylen + xlen) -
                                                               s))),
              nil_index_list()), "y")), "assigning variable z");}
    current_statement__ = 106;
    return z;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct convolve_with_rev_pmf_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
operator()(const T0__& x, const T1__& y, const int& len,
           std::ostream* pstream__)  const 
{
return convolve_with_rev_pmf(x, y, len, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
convolve_to_report(const T0__& infections_arg__,
                   const T1__& delay_rev_pmf_arg__, const int& seeding_time,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& infections = to_ref(infections_arg__);
  const auto& delay_rev_pmf = to_ref(delay_rev_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 108;
    t = num_elements(infections);
    current_statement__ = 109;
    validate_non_negative_index("reports", "t - seeding_time",
                                (t - seeding_time));
    Eigen::Matrix<local_scalar_t__, -1, 1> reports;
    reports = Eigen::Matrix<local_scalar_t__, -1, 1>((t - seeding_time));
    stan::math::fill(reports, DUMMY_VAR__);
    
    current_statement__ = 111;
    validate_non_negative_index("unobs_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> unobs_reports;
    unobs_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(unobs_reports, DUMMY_VAR__);
    
    current_statement__ = 112;
    assign(unobs_reports, nil_index_list(), infections,
      "assigning variable unobs_reports");
    int delays;
    delays = std::numeric_limits<int>::min();
    
    current_statement__ = 113;
    delays = num_elements(delay_rev_pmf);
    current_statement__ = 119;
    if (delays) {
      current_statement__ = 116;
      assign(unobs_reports, nil_index_list(),
        convolve_with_rev_pmf(stan::model::deep_copy(unobs_reports),
          delay_rev_pmf, t, pstream__), "assigning variable unobs_reports");
      current_statement__ = 117;
      assign(reports, nil_index_list(),
        rvalue(unobs_reports,
          cons_list(index_min_max((seeding_time + 1), t), nil_index_list()),
          "unobs_reports"), "assigning variable reports");
    } else {
      current_statement__ = 114;
      assign(reports, nil_index_list(),
        rvalue(infections,
          cons_list(index_min_max((seeding_time + 1), t), nil_index_list()),
          "infections"), "assigning variable reports");
    }
    current_statement__ = 120;
    return reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct convolve_to_report_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
operator()(const T0__& infections, const T1__& delay_rev_pmf,
           const int& seeding_time, std::ostream* pstream__)  const 
{
return convolve_to_report(infections, delay_rev_pmf, seeding_time, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<T0__,
T1__>, -1, 1>
discretised_pmf(const T0__& mu, const T1__& sigma, const int& n,
                const int& dist, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 122;
    validate_non_negative_index("lpmf", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> lpmf;
    lpmf = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(lpmf, DUMMY_VAR__);
    
    current_statement__ = 147;
    if (logical_gt(sigma, 0)) {
      current_statement__ = 127;
      validate_non_negative_index("upper_lcdf", "n", n);
      Eigen::Matrix<local_scalar_t__, -1, 1> upper_lcdf;
      upper_lcdf = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(upper_lcdf, DUMMY_VAR__);
      
      current_statement__ = 142;
      if (logical_eq(dist, 0)) {
        current_statement__ = 140;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 138;
          assign(upper_lcdf, cons_list(index_uni(i), nil_index_list()),
            lognormal_lcdf(i, mu, sigma), "assigning variable upper_lcdf");}
      } else {
        current_statement__ = 137;
        if (logical_eq(dist, 1)) {
          local_scalar_t__ alpha;
          alpha = DUMMY_VAR__;
          
          current_statement__ = 131;
          alpha = (pow(mu, 2) / pow(sigma, 2));
          local_scalar_t__ beta;
          beta = DUMMY_VAR__;
          
          current_statement__ = 132;
          beta = (mu / pow(sigma, 2));
          current_statement__ = 135;
          for (int i = 1; i <= n; ++i) {
            current_statement__ = 133;
            assign(upper_lcdf, cons_list(index_uni(i), nil_index_list()),
              gamma_lcdf(i, alpha, beta), "assigning variable upper_lcdf");}
        } else {
          current_statement__ = 129;
          std::stringstream errmsg_stream__;
          errmsg_stream__ << "Unknown distribution function provided.";
          throw std::domain_error(errmsg_stream__.str());
        }
      }
      current_statement__ = 143;
      assign(lpmf, cons_list(index_uni(1), nil_index_list()),
        upper_lcdf[(1 - 1)], "assigning variable lpmf");
      current_statement__ = 144;
      assign(lpmf, cons_list(index_min_max(2, n), nil_index_list()),
        log_diff_exp(
          rvalue(upper_lcdf,
            cons_list(index_min_max(2, n), nil_index_list()), "upper_lcdf"),
          rvalue(upper_lcdf,
            cons_list(index_min_max(1, (n - 1)), nil_index_list()),
            "upper_lcdf")), "assigning variable lpmf");
      current_statement__ = 145;
      assign(lpmf, nil_index_list(),
        subtract(stan::model::deep_copy(lpmf), upper_lcdf[(n - 1)]),
        "assigning variable lpmf");
    } else {
      current_statement__ = 124;
      assign(lpmf, nil_index_list(),
        rep_vector(stan::math::negative_infinity(), n),
        "assigning variable lpmf");
      current_statement__ = 125;
      assign(lpmf, cons_list(index_uni(n), nil_index_list()), 0,
        "assigning variable lpmf");
    }
    current_statement__ = 148;
    return stan::math::exp(lpmf);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct discretised_pmf_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<T0__,
T1__>, -1, 1>
operator()(const T0__& mu, const T1__& sigma, const int& n, const int& dist,
           std::ostream* pstream__)  const 
{
return discretised_pmf(mu, sigma, n, dist, pstream__);
}
};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
reverse_mf(const T0__& pmf_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& pmf = to_ref(pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int max_pmf;
    max_pmf = std::numeric_limits<int>::min();
    
    current_statement__ = 150;
    max_pmf = num_elements(pmf);
    current_statement__ = 151;
    validate_non_negative_index("rev_pmf", "max_pmf", max_pmf);
    Eigen::Matrix<local_scalar_t__, -1, 1> rev_pmf;
    rev_pmf = Eigen::Matrix<local_scalar_t__, -1, 1>(max_pmf);
    stan::math::fill(rev_pmf, DUMMY_VAR__);
    
    current_statement__ = 155;
    for (int d = 1; d <= max_pmf; ++d) {
      current_statement__ = 153;
      assign(rev_pmf, cons_list(index_uni(d), nil_index_list()),
        pmf[(((max_pmf - d) + 1) - 1)], "assigning variable rev_pmf");}
    current_statement__ = 156;
    return rev_pmf;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct reverse_mf_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
operator()(const T0__& pmf, std::ostream* pstream__)  const 
{
return reverse_mf(pmf, pstream__);
}
};
Eigen::Matrix<double, -1, 1>
rev_seq(const int& base, const int& len, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 158;
    validate_non_negative_index("seq", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> seq;
    seq = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(seq, DUMMY_VAR__);
    
    current_statement__ = 162;
    for (int i = 1; i <= len; ++i) {
      current_statement__ = 160;
      assign(seq, cons_list(index_uni(i), nil_index_list()),
        ((len + base) - i), "assigning variable seq");}
    current_statement__ = 163;
    return seq;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct rev_seq_functor__ {
Eigen::Matrix<double, -1, 1>
operator()(const int& base, const int& len, std::ostream* pstream__)  const 
{
return rev_seq(base, len, pstream__);
}
};
template <typename T0__>
stan::promote_args_t<stan::value_type_t<T0__>>
rev_pmf_mean(const T0__& rev_pmf_arg__, const int& base,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& rev_pmf = to_ref(rev_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int len;
    len = std::numeric_limits<int>::min();
    
    current_statement__ = 165;
    len = num_elements(rev_pmf);
    current_statement__ = 166;
    validate_non_negative_index("rev_pmf_seq", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> rev_pmf_seq;
    rev_pmf_seq = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(rev_pmf_seq, DUMMY_VAR__);
    
    current_statement__ = 167;
    assign(rev_pmf_seq, nil_index_list(), rev_seq(base, len, pstream__),
      "assigning variable rev_pmf_seq");
    current_statement__ = 168;
    return dot_product(rev_pmf_seq, rev_pmf);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct rev_pmf_mean_functor__ {
template <typename T0__>
stan::promote_args_t<stan::value_type_t<T0__>>
operator()(const T0__& rev_pmf, const int& base, std::ostream* pstream__)  const 
{
return rev_pmf_mean(rev_pmf, base, pstream__);
}
};
template <typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
T2__>
rev_pmf_var(const T0__& rev_pmf_arg__, const int& base, const T2__& mean,
            std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T2__>;
  const auto& rev_pmf = to_ref(rev_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int len;
    len = std::numeric_limits<int>::min();
    
    current_statement__ = 170;
    len = num_elements(rev_pmf);
    current_statement__ = 171;
    validate_non_negative_index("rev_pmf_seq", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> rev_pmf_seq;
    rev_pmf_seq = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(rev_pmf_seq, DUMMY_VAR__);
    
    current_statement__ = 172;
    assign(rev_pmf_seq, nil_index_list(), rev_seq(base, len, pstream__),
      "assigning variable rev_pmf_seq");
    current_statement__ = 175;
    for (int i = 1; i <= len; ++i) {
      current_statement__ = 173;
      assign(rev_pmf_seq, cons_list(index_uni(i), nil_index_list()),
        pow(rev_pmf_seq[(i - 1)], 2), "assigning variable rev_pmf_seq");}
    current_statement__ = 176;
    return (dot_product(rev_pmf_seq, rev_pmf) - pow(mean, 2));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct rev_pmf_var_functor__ {
template <typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
T2__>
operator()(const T0__& rev_pmf, const int& base, const T2__& mean,
           std::ostream* pstream__)  const 
{
return rev_pmf_var(rev_pmf, base, mean, pstream__);
}
};
template <typename T0__, typename T2__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>, -1, 1>
day_of_week_effect(const T0__& reports_arg__,
                   const std::vector<int>& day_of_week,
                   const T2__& effect_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>>;
  const auto& reports = to_ref(reports_arg__);
  const auto& effect = to_ref(effect_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 178;
    t = num_elements(reports);
    int wl;
    wl = std::numeric_limits<int>::min();
    
    current_statement__ = 179;
    wl = num_elements(effect);
    current_statement__ = 180;
    validate_non_negative_index("scaled_effect", "wl", wl);
    Eigen::Matrix<local_scalar_t__, -1, 1> scaled_effect;
    scaled_effect = Eigen::Matrix<local_scalar_t__, -1, 1>(wl);
    stan::math::fill(scaled_effect, DUMMY_VAR__);
    
    current_statement__ = 181;
    assign(scaled_effect, nil_index_list(), multiply(wl, effect),
      "assigning variable scaled_effect");
    current_statement__ = 182;
    validate_non_negative_index("scaled_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> scaled_reports;
    scaled_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(scaled_reports, DUMMY_VAR__);
    
    current_statement__ = 186;
    for (int s = 1; s <= t; ++s) {
      current_statement__ = 184;
      assign(scaled_reports, cons_list(index_uni(s), nil_index_list()),
        (reports[(s - 1)] * scaled_effect[(day_of_week[(s - 1)] - 1)]),
        "assigning variable scaled_reports");}
    current_statement__ = 187;
    return scaled_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct day_of_week_effect_functor__ {
template <typename T0__, typename T2__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>, -1, 1>
operator()(const T0__& reports, const std::vector<int>& day_of_week,
           const T2__& effect, std::ostream* pstream__)  const 
{
return day_of_week_effect(reports, day_of_week, effect, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
T1__>, -1, 1>
scale_obs(const T0__& reports_arg__, const T1__& frac_obs,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T1__>;
  const auto& reports = to_ref(reports_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 189;
    t = num_elements(reports);
    current_statement__ = 190;
    validate_non_negative_index("scaled_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> scaled_reports;
    scaled_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(scaled_reports, DUMMY_VAR__);
    
    current_statement__ = 192;
    assign(scaled_reports, nil_index_list(), multiply(reports, frac_obs),
      "assigning variable scaled_reports");
    current_statement__ = 193;
    return scaled_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct scale_obs_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
T1__>, -1, 1>
operator()(const T0__& reports, const T1__& frac_obs, std::ostream* pstream__)  const 
{
return scale_obs(reports, frac_obs, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
truncate(const T0__& reports_arg__, const T1__& trunc_rev_cmf_arg__,
         const int& reconstruct, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& reports = to_ref(reports_arg__);
  const auto& trunc_rev_cmf = to_ref(trunc_rev_cmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 195;
    t = num_elements(reports);
    current_statement__ = 196;
    validate_non_negative_index("trunc_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> trunc_reports;
    trunc_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(trunc_reports, DUMMY_VAR__);
    
    current_statement__ = 197;
    assign(trunc_reports, nil_index_list(), reports,
      "assigning variable trunc_reports");
    int trunc_max;
    trunc_max = std::numeric_limits<int>::min();
    
    current_statement__ = 198;
    trunc_max = std::min(t, num_elements(trunc_rev_cmf));
    int first_t;
    first_t = std::numeric_limits<int>::min();
    
    current_statement__ = 199;
    first_t = ((t - trunc_max) + 1);
    current_statement__ = 204;
    if (reconstruct) {
      current_statement__ = 202;
      assign(trunc_reports,
        cons_list(index_min_max(first_t, t), nil_index_list()),
        elt_divide(
          stan::model::deep_copy(
            rvalue(trunc_reports,
              cons_list(index_min_max(first_t, t), nil_index_list()),
              "trunc_reports")),
          rvalue(trunc_rev_cmf,
            cons_list(index_min_max(1, trunc_max), nil_index_list()),
            "trunc_rev_cmf")), "assigning variable trunc_reports");
    } else {
      current_statement__ = 200;
      assign(trunc_reports,
        cons_list(index_min_max(first_t, t), nil_index_list()),
        elt_multiply(
          stan::model::deep_copy(
            rvalue(trunc_reports,
              cons_list(index_min_max(first_t, t), nil_index_list()),
              "trunc_reports")),
          rvalue(trunc_rev_cmf,
            cons_list(index_min_max(1, trunc_max), nil_index_list()),
            "trunc_rev_cmf")), "assigning variable trunc_reports");
    }
    current_statement__ = 205;
    return trunc_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct truncate_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
operator()(const T0__& reports, const T1__& trunc_rev_cmf,
           const int& reconstruct, std::ostream* pstream__)  const 
{
return truncate(reports, trunc_rev_cmf, reconstruct, pstream__);
}
};
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T_lp__,
typename T_lp_accum__>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
              const std::vector<T1__>& truncation_sd,
              const std::vector<T2__>& trunc_mean_mean,
              const std::vector<T3__>& trunc_mean_sd,
              const std::vector<T4__>& trunc_sd_mean,
              const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__,
              T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          T1__,
          T2__,
          T3__,
          T4__, stan::promote_args_t<T5__>>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int truncation;
    truncation = std::numeric_limits<int>::min();
    
    current_statement__ = 207;
    truncation = num_elements(truncation_mean);
    current_statement__ = 215;
    if (truncation) {
      current_statement__ = 210;
      if (logical_gt(trunc_mean_sd[(1 - 1)], 0)) {
        current_statement__ = 208;
        lp_accum__.add(
          normal_lpdf<propto__>(truncation_mean, trunc_mean_mean,
            trunc_mean_sd));
      } 
      current_statement__ = 213;
      if (logical_gt(trunc_sd_sd[(1 - 1)], 0)) {
        current_statement__ = 211;
        lp_accum__.add(
          normal_lpdf<propto__>(truncation_sd, trunc_sd_mean, trunc_sd_sd));
      } 
    } 
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct truncation_lp_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T_lp__,
typename T_lp_accum__>
void
operator()(const std::vector<T0__>& truncation_mean,
           const std::vector<T1__>& truncation_sd,
           const std::vector<T2__>& trunc_mean_mean,
           const std::vector<T3__>& trunc_mean_sd,
           const std::vector<T4__>& trunc_sd_mean,
           const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__,
           T_lp_accum__& lp_accum__, std::ostream* pstream__)  const 
{
return truncation_lp<propto__>(truncation_mean, truncation_sd,
         trunc_mean_mean, trunc_mean_sd, trunc_sd_mean, trunc_sd_sd, lp__,
         lp_accum__, pstream__);
}
};
template <bool propto__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
void
report_lp(const std::vector<int>& cases, const T1__& reports_arg__,
          const std::vector<T2__>& rep_phi, const T3__& phi_mean,
          const T4__& phi_sd, const int& model_type, const T6__& weight,
          T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T1__>,
          T2__,
          T3__,
          T4__,
          T6__>;
  const auto& reports = to_ref(reports_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 233;
    if (model_type) {
      local_scalar_t__ sqrt_phi;
      sqrt_phi = DUMMY_VAR__;
      
      current_statement__ = 224;
      if (logical_lt(rep_phi[(model_type - 1)], 0)) {
        current_statement__ = 224;
        lp_accum__.add(stan::math::negative_infinity());
      } else {
        current_statement__ = 224;
        lp_accum__.add(-normal_ccdf_log(0, phi_mean, phi_sd));
      }
      current_statement__ = 225;
      lp_accum__.add(
        normal_lpdf<propto__>(rep_phi[(model_type - 1)], phi_mean, phi_sd));
      current_statement__ = 226;
      sqrt_phi = (1 / stan::math::sqrt(rep_phi[(model_type - 1)]));
      current_statement__ = 231;
      if (logical_eq(weight, 1)) {
        current_statement__ = 229;
        lp_accum__.add(
          neg_binomial_2_lpmf<propto__>(cases, reports, sqrt_phi));
      } else {
        current_statement__ = 227;
        lp_accum__.add(
          (neg_binomial_2_lpmf<false>(cases, reports, sqrt_phi) * weight));
      }
    } else {
      current_statement__ = 221;
      if (logical_eq(weight, 1)) {
        current_statement__ = 219;
        lp_accum__.add(poisson_lpmf<propto__>(cases, reports));
      } else {
        current_statement__ = 217;
        lp_accum__.add((poisson_lpmf<false>(cases, reports) * weight));
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct report_lp_functor__ {
template <bool propto__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
void
operator()(const std::vector<int>& cases, const T1__& reports,
           const std::vector<T2__>& rep_phi, const T3__& phi_mean,
           const T4__& phi_sd, const int& model_type, const T6__& weight,
           T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__)  const 
{
return report_lp<propto__>(cases, reports, rep_phi, phi_mean, phi_sd,
         model_type, weight, lp__, lp_accum__, pstream__);
}
};
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T1__>, T2__,
T4__>, -1, 1>
report_log_lik(const std::vector<int>& cases, const T1__& reports_arg__,
               const std::vector<T2__>& rep_phi, const int& model_type,
               const T4__& weight, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T1__>,
          T2__,
          T4__>;
  const auto& reports = to_ref(reports_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 235;
    t = num_elements(reports);
    current_statement__ = 236;
    validate_non_negative_index("log_lik", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> log_lik;
    log_lik = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(log_lik, DUMMY_VAR__);
    
    current_statement__ = 247;
    if (logical_eq(model_type, 0)) {
      current_statement__ = 245;
      for (int i = 1; i <= t; ++i) {
        current_statement__ = 243;
        assign(log_lik, cons_list(index_uni(i), nil_index_list()),
          (poisson_lpmf<false>(cases[(i - 1)], reports[(i - 1)]) * weight),
          "assigning variable log_lik");}
    } else {
      local_scalar_t__ sqrt_phi;
      sqrt_phi = DUMMY_VAR__;
      
      current_statement__ = 238;
      sqrt_phi = (1 / stan::math::sqrt(rep_phi[(model_type - 1)]));
      current_statement__ = 241;
      for (int i = 1; i <= t; ++i) {
        current_statement__ = 239;
        assign(log_lik, cons_list(index_uni(i), nil_index_list()),
          (neg_binomial_2_lpmf<false>(cases[(i - 1)], reports[(i - 1)],
             sqrt_phi) * weight), "assigning variable log_lik");}
    }
    current_statement__ = 248;
    return log_lik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct report_log_lik_functor__ {
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T1__>, T2__,
T4__>, -1, 1>
operator()(const std::vector<int>& cases, const T1__& reports,
           const std::vector<T2__>& rep_phi, const int& model_type,
           const T4__& weight, std::ostream* pstream__)  const 
{
return report_log_lik(cases, reports, rep_phi, model_type, weight, pstream__);
}
};
template <typename T0__, typename T1__, typename RNG>
std::vector<int>
report_rng(const T0__& reports_arg__, const std::vector<T1__>& rep_phi,
           const int& model_type, RNG& base_rng__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T1__>;
  const auto& reports = to_ref(reports_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 250;
    t = num_elements(reports);
    current_statement__ = 251;
    validate_non_negative_index("sampled_reports", "t", t);
    std::vector<int> sampled_reports;
    sampled_reports = std::vector<int>(t, std::numeric_limits<int>::min());
    
    local_scalar_t__ sqrt_phi;
    sqrt_phi = DUMMY_VAR__;
    
    current_statement__ = 253;
    sqrt_phi = 1e5;
    current_statement__ = 256;
    if (model_type) {
      current_statement__ = 254;
      sqrt_phi = (1 / stan::math::sqrt(rep_phi[(model_type - 1)]));
    } 
    current_statement__ = 267;
    for (int s = 1; s <= t; ++s) {
      current_statement__ = 265;
      if (logical_lt(reports[(s - 1)], 1e-8)) {
        current_statement__ = 263;
        assign(sampled_reports, cons_list(index_uni(s), nil_index_list()), 0,
          "assigning variable sampled_reports");
      } else {
        current_statement__ = 261;
        if (logical_gt(sqrt_phi, 1e4)) {
          current_statement__ = 259;
          assign(sampled_reports, cons_list(index_uni(s), nil_index_list()),
            poisson_rng(
              (logical_gt(reports[(s - 1)], 1e8) ?
                 stan::math::promote_scalar<local_scalar_t__>(1e8) :
                 stan::math::promote_scalar<local_scalar_t__>(reports[
                 (s - 1)])), base_rng__),
            "assigning variable sampled_reports");
        } else {
          current_statement__ = 257;
          assign(sampled_reports, cons_list(index_uni(s), nil_index_list()),
            neg_binomial_2_rng(
              (logical_gt(reports[(s - 1)], 1e8) ?
                 stan::math::promote_scalar<local_scalar_t__>(1e8) :
                 stan::math::promote_scalar<local_scalar_t__>(reports[
                 (s - 1)])), sqrt_phi, base_rng__),
            "assigning variable sampled_reports");
        }
      }}
    current_statement__ = 268;
    return sampled_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct report_rng_functor__ {
template <typename T0__, typename T1__, typename RNG>
std::vector<int>
operator()(const T0__& reports, const std::vector<T1__>& rep_phi,
           const int& model_type, RNG& base_rng__, std::ostream* pstream__)  const 
{
return report_rng(reports, rep_phi, model_type, base_rng__, pstream__);
}
};
std::vector<int>
get_delay_type_max(const int& delay_types,
                   const std::vector<int>& delay_types_p,
                   const std::vector<int>& delay_types_id,
                   const std::vector<int>& delay_types_groups,
                   const std::vector<int>& delay_max,
                   const std::vector<int>& delay_np_pmf_groups,
                   std::ostream* pstream__) {
  using local_scalar_t__ = double;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 270;
    validate_non_negative_index("ret", "delay_types", delay_types);
    std::vector<int> ret;
    ret = std::vector<int>(delay_types, std::numeric_limits<int>::min());
    
    current_statement__ = 281;
    for (int i = 1; i <= delay_types; ++i) {
      current_statement__ = 272;
      assign(ret, cons_list(index_uni(i), nil_index_list()), 1,
        "assigning variable ret");
      current_statement__ = 279;
      for (int j = delay_types_groups[(i - 1)];
           j <= (delay_types_groups[((i + 1) - 1)] - 1); ++j) {
        current_statement__ = 277;
        if (delay_types_p[(j - 1)]) {
          current_statement__ = 275;
          assign(ret, cons_list(index_uni(i), nil_index_list()),
            (ret[(i - 1)] + (delay_max[(delay_types_id[(j - 1)] - 1)] - 1)),
            "assigning variable ret");
        } else {
          current_statement__ = 273;
          assign(ret, cons_list(index_uni(i), nil_index_list()),
            (ret[(i - 1)] +
              ((delay_np_pmf_groups[((delay_types_id[(j - 1)] + 1) - 1)] -
                 delay_np_pmf_groups[(delay_types_id[(j - 1)] - 1)]) - 1)),
            "assigning variable ret");
        }}}
    current_statement__ = 282;
    return ret;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct get_delay_type_max_functor__ {
std::vector<int>
operator()(const int& delay_types, const std::vector<int>& delay_types_p,
           const std::vector<int>& delay_types_id,
           const std::vector<int>& delay_types_groups,
           const std::vector<int>& delay_max,
           const std::vector<int>& delay_np_pmf_groups,
           std::ostream* pstream__)  const 
{
return get_delay_type_max(delay_types, delay_types_p, delay_types_id,
         delay_types_groups, delay_max, delay_np_pmf_groups, pstream__);
}
};
template <typename T6__, typename T8__, typename T9__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T6__>, T8__,
T9__>, -1, 1>
get_delay_rev_pmf(const int& delay_id, const int& len,
                  const std::vector<int>& delay_types_p,
                  const std::vector<int>& delay_types_id,
                  const std::vector<int>& delay_types_groups,
                  const std::vector<int>& delay_max,
                  const T6__& delay_np_pmf_arg__,
                  const std::vector<int>& delay_np_pmf_groups,
                  const std::vector<T8__>& delay_mean,
                  const std::vector<T9__>& delay_sigma,
                  const std::vector<int>& delay_dist,
                  const int& left_truncate, const int& reverse_pmf,
                  const int& cumulative, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T6__>,
          T8__,
          T9__>;
  const auto& delay_np_pmf = to_ref(delay_np_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 284;
    validate_non_negative_index("pmf", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> pmf;
    pmf = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(pmf, DUMMY_VAR__);
    
    current_statement__ = 285;
    assign(pmf, nil_index_list(), rep_vector(0, len),
      "assigning variable pmf");
    int current_len;
    current_len = std::numeric_limits<int>::min();
    
    current_statement__ = 286;
    current_len = 1;
    int new_len;
    new_len = std::numeric_limits<int>::min();
    
    current_statement__ = 309;
    for (int i = delay_types_groups[(delay_id - 1)];
         i <= (delay_types_groups[((delay_id + 1) - 1)] - 1); ++i) {
      current_statement__ = 306;
      if (delay_types_p[(i - 1)]) {
        current_statement__ = 297;
        validate_non_negative_index("new_variable_pmf",
                                    "delay_max[delay_types_id[i]]",
                                    delay_max[(delay_types_id[(i - 1)] - 1)]);
        Eigen::Matrix<local_scalar_t__, -1, 1> new_variable_pmf;
        new_variable_pmf = Eigen::Matrix<local_scalar_t__, -1, 1>(delay_max[
          (delay_types_id[(i - 1)] - 1)]);
        stan::math::fill(new_variable_pmf, DUMMY_VAR__);
        
        current_statement__ = 298;
        assign(new_variable_pmf, nil_index_list(),
          discretised_pmf(delay_mean[(delay_types_id[(i - 1)] - 1)],
            delay_sigma[(delay_types_id[(i - 1)] - 1)],
            delay_max[(delay_types_id[(i - 1)] - 1)],
            delay_dist[(delay_types_id[(i - 1)] - 1)], pstream__),
          "assigning variable new_variable_pmf");
        current_statement__ = 299;
        new_len = ((current_len + delay_max[(delay_types_id[(i - 1)] - 1)]) -
                    1);
        current_statement__ = 304;
        if (logical_eq(current_len, 1)) {
          current_statement__ = 302;
          assign(pmf, cons_list(index_min_max(1, new_len), nil_index_list()),
            new_variable_pmf, "assigning variable pmf");
        } else {
          current_statement__ = 300;
          assign(pmf, cons_list(index_min_max(1, new_len), nil_index_list()),
            convolve_with_rev_pmf(
              stan::model::deep_copy(
                rvalue(pmf,
                  cons_list(index_min_max(1, current_len), nil_index_list()),
                  "pmf")), reverse_mf(new_variable_pmf, pstream__),
              new_len, pstream__), "assigning variable pmf");
        }
      } else {
        int start;
        start = std::numeric_limits<int>::min();
        
        current_statement__ = 288;
        start = delay_np_pmf_groups[(delay_types_id[(i - 1)] - 1)];
        int end;
        end = std::numeric_limits<int>::min();
        
        current_statement__ = 289;
        end = (delay_np_pmf_groups[((delay_types_id[(i - 1)] + 1) - 1)] - 1);
        current_statement__ = 290;
        new_len = ((current_len + end) - start);
        current_statement__ = 295;
        if (logical_eq(current_len, 1)) {
          current_statement__ = 293;
          assign(pmf, cons_list(index_min_max(1, new_len), nil_index_list()),
            rvalue(delay_np_pmf,
              cons_list(index_min_max(start, end), nil_index_list()),
              "delay_np_pmf"), "assigning variable pmf");
        } else {
          current_statement__ = 291;
          assign(pmf, cons_list(index_min_max(1, new_len), nil_index_list()),
            convolve_with_rev_pmf(
              stan::model::deep_copy(
                rvalue(pmf,
                  cons_list(index_min_max(1, current_len), nil_index_list()),
                  "pmf")),
              reverse_mf(
                rvalue(delay_np_pmf,
                  cons_list(index_min_max(start, end), nil_index_list()),
                  "delay_np_pmf"), pstream__), new_len, pstream__),
            "assigning variable pmf");
        }
      }
      current_statement__ = 307;
      current_len = new_len;}
    current_statement__ = 312;
    if (left_truncate) {
      current_statement__ = 310;
      assign(pmf, nil_index_list(),
        append_row(rep_vector(0, left_truncate),
          divide(
            stan::model::deep_copy(
              rvalue(pmf,
                cons_list(index_min_max((left_truncate + 1), len),
                  nil_index_list()), "pmf")),
            sum(
              rvalue(pmf,
                cons_list(index_min_max((left_truncate + 1), len),
                  nil_index_list()), "pmf")))), "assigning variable pmf");
    } 
    current_statement__ = 315;
    if (cumulative) {
      current_statement__ = 313;
      assign(pmf, nil_index_list(),
        cumulative_sum(stan::model::deep_copy(pmf)), "assigning variable pmf");
    } 
    current_statement__ = 318;
    if (reverse_pmf) {
      current_statement__ = 316;
      assign(pmf, nil_index_list(),
        reverse_mf(stan::model::deep_copy(pmf), pstream__),
        "assigning variable pmf");
    } 
    current_statement__ = 319;
    return pmf;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct get_delay_rev_pmf_functor__ {
template <typename T6__, typename T8__, typename T9__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T6__>, T8__,
T9__>, -1, 1>
operator()(const int& delay_id, const int& len,
           const std::vector<int>& delay_types_p,
           const std::vector<int>& delay_types_id,
           const std::vector<int>& delay_types_groups,
           const std::vector<int>& delay_max, const T6__& delay_np_pmf,
           const std::vector<int>& delay_np_pmf_groups,
           const std::vector<T8__>& delay_mean,
           const std::vector<T9__>& delay_sigma,
           const std::vector<int>& delay_dist, const int& left_truncate,
           const int& reverse_pmf, const int& cumulative,
           std::ostream* pstream__)  const 
{
return get_delay_rev_pmf(delay_id, len, delay_types_p, delay_types_id,
         delay_types_groups, delay_max, delay_np_pmf, delay_np_pmf_groups,
         delay_mean, delay_sigma, delay_dist, left_truncate, reverse_pmf,
         cumulative, pstream__);
}
};
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T_lp__,
typename T_lp_accum__>
void
delays_lp(const std::vector<T0__>& delay_mean,
          const std::vector<T1__>& delay_mean_mean,
          const std::vector<T2__>& delay_mean_sd,
          const std::vector<T3__>& delay_sd,
          const std::vector<T4__>& delay_sd_mean,
          const std::vector<T5__>& delay_sd_sd,
          const std::vector<int>& delay_dist, const std::vector<int>& weight,
          T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          T1__,
          T2__,
          T3__,
          T4__, stan::promote_args_t<T5__>>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int mean_delays;
    mean_delays = std::numeric_limits<int>::min();
    
    current_statement__ = 321;
    mean_delays = num_elements(delay_mean);
    int sd_delays;
    sd_delays = std::numeric_limits<int>::min();
    
    current_statement__ = 322;
    sd_delays = num_elements(delay_sd);
    current_statement__ = 332;
    if (mean_delays) {
      current_statement__ = 330;
      for (int s = 1; s <= mean_delays; ++s) {
        current_statement__ = 328;
        if (logical_gt(delay_mean_sd[(s - 1)], 0)) {
          current_statement__ = 323;
          lp_accum__.add(
            (normal_lpdf<false>(delay_mean[(s - 1)],
               delay_mean_mean[(s - 1)], delay_mean_sd[(s - 1)]) *
              weight[(s - 1)]));
          current_statement__ = 326;
          if (delay_dist[(s - 1)]) {
            current_statement__ = 324;
            lp_accum__.add(
              (-normal_lccdf(0, delay_mean_mean[(s - 1)],
                  delay_mean_sd[(s - 1)]) * weight[(s - 1)]));
          } 
        } }
    } 
    current_statement__ = 340;
    if (sd_delays) {
      current_statement__ = 338;
      for (int s = 1; s <= sd_delays; ++s) {
        current_statement__ = 336;
        if (logical_gt(delay_sd_sd[(s - 1)], 0)) {
          current_statement__ = 333;
          lp_accum__.add(
            (normal_lpdf<false>(delay_sd[(s - 1)], delay_sd_mean[(s - 1)],
               delay_sd_sd[(s - 1)]) * weight[(s - 1)]));
          current_statement__ = 334;
          lp_accum__.add(
            (-normal_lccdf(0, delay_sd_mean[(s - 1)], delay_sd_sd[(s - 1)]) *
              weight[(s - 1)]));
        } }
    } 
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct delays_lp_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T_lp__,
typename T_lp_accum__>
void
operator()(const std::vector<T0__>& delay_mean,
           const std::vector<T1__>& delay_mean_mean,
           const std::vector<T2__>& delay_mean_sd,
           const std::vector<T3__>& delay_sd,
           const std::vector<T4__>& delay_sd_mean,
           const std::vector<T5__>& delay_sd_sd,
           const std::vector<int>& delay_dist,
           const std::vector<int>& weight, T_lp__& lp__,
           T_lp_accum__& lp_accum__, std::ostream* pstream__)  const 
{
return delays_lp<propto__>(delay_mean, delay_mean_mean, delay_mean_sd,
         delay_sd, delay_sd_mean, delay_sd_sd, delay_dist, weight, lp__,
         lp_accum__, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_estimate_truncation final : public model_base_crtp<model_estimate_truncation> {
private:
  int t;
  int obs_sets;
  std::vector<std::vector<int>> obs;
  std::vector<int> obs_dist;
  int delay_n;
  int delay_n_p;
  int delay_n_np;
  std::vector<double> delay_mean_mean;
  std::vector<double> delay_mean_sd;
  std::vector<double> delay_sd_mean;
  std::vector<double> delay_sd_sd;
  std::vector<int> delay_max;
  std::vector<int> delay_dist;
  int delay_np_pmf_max;
  Eigen::Matrix<double, -1, 1> delay_np_pmf;
  std::vector<int> delay_np_pmf_groups;
  std::vector<int> delay_weight;
  int delay_types;
  std::vector<int> delay_types_p;
  std::vector<int> delay_types_id;
  std::vector<int> delay_types_groups;
  int trunc_id;
  std::vector<int> end_t;
  std::vector<int> start_t;
  std::vector<int> delay_type_max;
  int trunc_obs_1dim__;
  int trunc_obs_2dim__;
  int trunc_rev_cmf_1dim__;
  int recon_obs_1dim__;
  int gen_obs_1dim__;
  int gen_obs_2dim__;
 
public:
  ~model_estimate_truncation() { }
  
  inline std::string model_name() const final { return "model_estimate_truncation"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_estimate_truncation(stan::io::var_context& context__,
                            unsigned int random_seed__ = 0,
                            std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_estimate_truncation_namespace::model_estimate_truncation";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 39;
      context__.validate_dims("data initialization","t","int",
          context__.to_vec());
      t = std::numeric_limits<int>::min();
      
      current_statement__ = 39;
      t = context__.vals_i("t")[(1 - 1)];
      current_statement__ = 40;
      context__.validate_dims("data initialization","obs_sets","int",
          context__.to_vec());
      obs_sets = std::numeric_limits<int>::min();
      
      current_statement__ = 40;
      obs_sets = context__.vals_i("obs_sets")[(1 - 1)];
      current_statement__ = 41;
      validate_non_negative_index("obs", "t", t);
      current_statement__ = 42;
      validate_non_negative_index("obs", "obs_sets", obs_sets);
      current_statement__ = 43;
      context__.validate_dims("data initialization","obs","int",
          context__.to_vec(t, obs_sets));
      obs = std::vector<std::vector<int>>(t, std::vector<int>(obs_sets, std::numeric_limits<int>::min()));
      
      {
        std::vector<int> obs_flat__;
        current_statement__ = 43;
        assign(obs_flat__, nil_index_list(), context__.vals_i("obs"),
          "assigning variable obs_flat__");
        current_statement__ = 43;
        pos__ = 1;
        current_statement__ = 43;
        for (int sym1__ = 1; sym1__ <= obs_sets; ++sym1__) {
          current_statement__ = 43;
          for (int sym2__ = 1; sym2__ <= t; ++sym2__) {
            current_statement__ = 43;
            assign(obs,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              obs_flat__[(pos__ - 1)], "assigning variable obs");
            current_statement__ = 43;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 44;
      validate_non_negative_index("obs_dist", "obs_sets", obs_sets);
      current_statement__ = 45;
      context__.validate_dims("data initialization","obs_dist","int",
          context__.to_vec(obs_sets));
      obs_dist = std::vector<int>(obs_sets, std::numeric_limits<int>::min());
      
      current_statement__ = 45;
      assign(obs_dist, nil_index_list(), context__.vals_i("obs_dist"),
        "assigning variable obs_dist");
      current_statement__ = 46;
      context__.validate_dims("data initialization","delay_n","int",
          context__.to_vec());
      delay_n = std::numeric_limits<int>::min();
      
      current_statement__ = 46;
      delay_n = context__.vals_i("delay_n")[(1 - 1)];
      current_statement__ = 46;
      current_statement__ = 46;
      check_greater_or_equal(function__, "delay_n", delay_n, 0);
      current_statement__ = 47;
      context__.validate_dims("data initialization","delay_n_p","int",
          context__.to_vec());
      delay_n_p = std::numeric_limits<int>::min();
      
      current_statement__ = 47;
      delay_n_p = context__.vals_i("delay_n_p")[(1 - 1)];
      current_statement__ = 47;
      current_statement__ = 47;
      check_greater_or_equal(function__, "delay_n_p", delay_n_p, 0);
      current_statement__ = 48;
      context__.validate_dims("data initialization","delay_n_np","int",
          context__.to_vec());
      delay_n_np = std::numeric_limits<int>::min();
      
      current_statement__ = 48;
      delay_n_np = context__.vals_i("delay_n_np")[(1 - 1)];
      current_statement__ = 48;
      current_statement__ = 48;
      check_greater_or_equal(function__, "delay_n_np", delay_n_np, 0);
      current_statement__ = 49;
      validate_non_negative_index("delay_mean_mean", "delay_n_p", delay_n_p);
      current_statement__ = 50;
      context__.validate_dims("data initialization","delay_mean_mean",
          "double",context__.to_vec(delay_n_p));
      delay_mean_mean = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 50;
      assign(delay_mean_mean, nil_index_list(),
        context__.vals_r("delay_mean_mean"),
        "assigning variable delay_mean_mean");
      current_statement__ = 51;
      validate_non_negative_index("delay_mean_sd", "delay_n_p", delay_n_p);
      current_statement__ = 52;
      context__.validate_dims("data initialization","delay_mean_sd","double",
          context__.to_vec(delay_n_p));
      delay_mean_sd = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 52;
      assign(delay_mean_sd, nil_index_list(),
        context__.vals_r("delay_mean_sd"), "assigning variable delay_mean_sd");
      current_statement__ = 52;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 52;
        current_statement__ = 52;
        check_greater_or_equal(function__, "delay_mean_sd[sym1__]",
                               delay_mean_sd[(sym1__ - 1)], 0);}
      current_statement__ = 53;
      validate_non_negative_index("delay_sd_mean", "delay_n_p", delay_n_p);
      current_statement__ = 54;
      context__.validate_dims("data initialization","delay_sd_mean","double",
          context__.to_vec(delay_n_p));
      delay_sd_mean = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 54;
      assign(delay_sd_mean, nil_index_list(),
        context__.vals_r("delay_sd_mean"), "assigning variable delay_sd_mean");
      current_statement__ = 54;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 54;
        current_statement__ = 54;
        check_greater_or_equal(function__, "delay_sd_mean[sym1__]",
                               delay_sd_mean[(sym1__ - 1)], 0);}
      current_statement__ = 55;
      validate_non_negative_index("delay_sd_sd", "delay_n_p", delay_n_p);
      current_statement__ = 56;
      context__.validate_dims("data initialization","delay_sd_sd","double",
          context__.to_vec(delay_n_p));
      delay_sd_sd = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 56;
      assign(delay_sd_sd, nil_index_list(), context__.vals_r("delay_sd_sd"),
        "assigning variable delay_sd_sd");
      current_statement__ = 56;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 56;
        current_statement__ = 56;
        check_greater_or_equal(function__, "delay_sd_sd[sym1__]",
                               delay_sd_sd[(sym1__ - 1)], 0);}
      current_statement__ = 57;
      validate_non_negative_index("delay_max", "delay_n_p", delay_n_p);
      current_statement__ = 58;
      context__.validate_dims("data initialization","delay_max","int",
          context__.to_vec(delay_n_p));
      delay_max = std::vector<int>(delay_n_p, std::numeric_limits<int>::min());
      
      current_statement__ = 58;
      assign(delay_max, nil_index_list(), context__.vals_i("delay_max"),
        "assigning variable delay_max");
      current_statement__ = 58;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 58;
        current_statement__ = 58;
        check_greater_or_equal(function__, "delay_max[sym1__]",
                               delay_max[(sym1__ - 1)], 1);}
      current_statement__ = 59;
      validate_non_negative_index("delay_dist", "delay_n_p", delay_n_p);
      current_statement__ = 60;
      context__.validate_dims("data initialization","delay_dist","int",
          context__.to_vec(delay_n_p));
      delay_dist = std::vector<int>(delay_n_p, std::numeric_limits<int>::min());
      
      current_statement__ = 60;
      assign(delay_dist, nil_index_list(), context__.vals_i("delay_dist"),
        "assigning variable delay_dist");
      current_statement__ = 60;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 60;
        current_statement__ = 60;
        check_greater_or_equal(function__, "delay_dist[sym1__]",
                               delay_dist[(sym1__ - 1)], 0);}
      current_statement__ = 61;
      context__.validate_dims("data initialization","delay_np_pmf_max","int",
          context__.to_vec());
      delay_np_pmf_max = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      delay_np_pmf_max = context__.vals_i("delay_np_pmf_max")[(1 - 1)];
      current_statement__ = 61;
      current_statement__ = 61;
      check_greater_or_equal(function__, "delay_np_pmf_max",
                             delay_np_pmf_max, 0);
      current_statement__ = 62;
      validate_non_negative_index("delay_np_pmf", "delay_np_pmf_max",
                                  delay_np_pmf_max);
      current_statement__ = 63;
      context__.validate_dims("data initialization","delay_np_pmf","double",
          context__.to_vec(delay_np_pmf_max));
      delay_np_pmf = Eigen::Matrix<double, -1, 1>(delay_np_pmf_max);
      stan::math::fill(delay_np_pmf, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> delay_np_pmf_flat__;
        current_statement__ = 63;
        assign(delay_np_pmf_flat__, nil_index_list(),
          context__.vals_r("delay_np_pmf"),
          "assigning variable delay_np_pmf_flat__");
        current_statement__ = 63;
        pos__ = 1;
        current_statement__ = 63;
        for (int sym1__ = 1; sym1__ <= delay_np_pmf_max; ++sym1__) {
          current_statement__ = 63;
          assign(delay_np_pmf,
            cons_list(index_uni(sym1__), nil_index_list()),
            delay_np_pmf_flat__[(pos__ - 1)],
            "assigning variable delay_np_pmf");
          current_statement__ = 63;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 63;
      for (int sym1__ = 1; sym1__ <= delay_np_pmf_max; ++sym1__) {
        current_statement__ = 63;
        current_statement__ = 63;
        check_greater_or_equal(function__, "delay_np_pmf[sym1__]",
                               delay_np_pmf[(sym1__ - 1)], 0);}
      current_statement__ = 63;
      for (int sym1__ = 1; sym1__ <= delay_np_pmf_max; ++sym1__) {
        current_statement__ = 63;
        current_statement__ = 63;
        check_less_or_equal(function__, "delay_np_pmf[sym1__]",
                            delay_np_pmf[(sym1__ - 1)], 1);}
      current_statement__ = 64;
      validate_non_negative_index("delay_np_pmf_groups", "delay_n_np + 1",
                                  (delay_n_np + 1));
      current_statement__ = 65;
      context__.validate_dims("data initialization","delay_np_pmf_groups",
          "int",context__.to_vec((delay_n_np + 1)));
      delay_np_pmf_groups = std::vector<int>((delay_n_np + 1), std::numeric_limits<int>::min());
      
      current_statement__ = 65;
      assign(delay_np_pmf_groups, nil_index_list(),
        context__.vals_i("delay_np_pmf_groups"),
        "assigning variable delay_np_pmf_groups");
      current_statement__ = 65;
      for (int sym1__ = 1; sym1__ <= (delay_n_np + 1); ++sym1__) {
        current_statement__ = 65;
        current_statement__ = 65;
        check_greater_or_equal(function__, "delay_np_pmf_groups[sym1__]",
                               delay_np_pmf_groups[(sym1__ - 1)], 1);}
      current_statement__ = 66;
      validate_non_negative_index("delay_weight", "delay_n_p", delay_n_p);
      current_statement__ = 67;
      context__.validate_dims("data initialization","delay_weight","int",
          context__.to_vec(delay_n_p));
      delay_weight = std::vector<int>(delay_n_p, std::numeric_limits<int>::min());
      
      current_statement__ = 67;
      assign(delay_weight, nil_index_list(),
        context__.vals_i("delay_weight"), "assigning variable delay_weight");
      current_statement__ = 67;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 67;
        current_statement__ = 67;
        check_greater_or_equal(function__, "delay_weight[sym1__]",
                               delay_weight[(sym1__ - 1)], 0);}
      current_statement__ = 68;
      context__.validate_dims("data initialization","delay_types","int",
          context__.to_vec());
      delay_types = std::numeric_limits<int>::min();
      
      current_statement__ = 68;
      delay_types = context__.vals_i("delay_types")[(1 - 1)];
      current_statement__ = 68;
      current_statement__ = 68;
      check_greater_or_equal(function__, "delay_types", delay_types, 0);
      current_statement__ = 69;
      validate_non_negative_index("delay_types_p", "delay_n", delay_n);
      current_statement__ = 70;
      context__.validate_dims("data initialization","delay_types_p","int",
          context__.to_vec(delay_n));
      delay_types_p = std::vector<int>(delay_n, std::numeric_limits<int>::min());
      
      current_statement__ = 70;
      assign(delay_types_p, nil_index_list(),
        context__.vals_i("delay_types_p"), "assigning variable delay_types_p");
      current_statement__ = 70;
      for (int sym1__ = 1; sym1__ <= delay_n; ++sym1__) {
        current_statement__ = 70;
        current_statement__ = 70;
        check_greater_or_equal(function__, "delay_types_p[sym1__]",
                               delay_types_p[(sym1__ - 1)], 0);}
      current_statement__ = 71;
      validate_non_negative_index("delay_types_id", "delay_n", delay_n);
      current_statement__ = 72;
      context__.validate_dims("data initialization","delay_types_id","int",
          context__.to_vec(delay_n));
      delay_types_id = std::vector<int>(delay_n, std::numeric_limits<int>::min());
      
      current_statement__ = 72;
      assign(delay_types_id, nil_index_list(),
        context__.vals_i("delay_types_id"),
        "assigning variable delay_types_id");
      current_statement__ = 72;
      for (int sym1__ = 1; sym1__ <= delay_n; ++sym1__) {
        current_statement__ = 72;
        current_statement__ = 72;
        check_greater_or_equal(function__, "delay_types_id[sym1__]",
                               delay_types_id[(sym1__ - 1)], 0);}
      current_statement__ = 73;
      validate_non_negative_index("delay_types_groups", "delay_types + 1",
                                  (delay_types + 1));
      current_statement__ = 74;
      context__.validate_dims("data initialization","delay_types_groups",
          "int",context__.to_vec((delay_types + 1)));
      delay_types_groups = std::vector<int>((delay_types + 1), std::numeric_limits<int>::min());
      
      current_statement__ = 74;
      assign(delay_types_groups, nil_index_list(),
        context__.vals_i("delay_types_groups"),
        "assigning variable delay_types_groups");
      current_statement__ = 74;
      for (int sym1__ = 1; sym1__ <= (delay_types + 1); ++sym1__) {
        current_statement__ = 74;
        current_statement__ = 74;
        check_greater_or_equal(function__, "delay_types_groups[sym1__]",
                               delay_types_groups[(sym1__ - 1)], 0);}
      current_statement__ = 75;
      trunc_id = std::numeric_limits<int>::min();
      
      current_statement__ = 75;
      trunc_id = 1;
      current_statement__ = 76;
      validate_non_negative_index("end_t", "obs_sets", obs_sets);
      current_statement__ = 77;
      end_t = std::vector<int>(obs_sets, std::numeric_limits<int>::min());
      
      current_statement__ = 78;
      validate_non_negative_index("start_t", "obs_sets", obs_sets);
      current_statement__ = 79;
      start_t = std::vector<int>(obs_sets, std::numeric_limits<int>::min());
      
      current_statement__ = 80;
      validate_non_negative_index("delay_type_max", "delay_types",
                                  delay_types);
      current_statement__ = 81;
      delay_type_max = std::vector<int>(delay_types, std::numeric_limits<int>::min());
      
      current_statement__ = 82;
      assign(delay_type_max, nil_index_list(),
        get_delay_type_max(delay_types, delay_types_p, delay_types_id,
          delay_types_groups, delay_max, delay_np_pmf_groups, pstream__),
        "assigning variable delay_type_max");
      current_statement__ = 86;
      for (int i = 1; i <= obs_sets; ++i) {
        current_statement__ = 83;
        assign(end_t, cons_list(index_uni(i), nil_index_list()),
          (t - obs_dist[(i - 1)]), "assigning variable end_t");
        current_statement__ = 84;
        assign(start_t, cons_list(index_uni(i), nil_index_list()),
          std::max(1,
            ((end_t[(i - 1)] - delay_type_max[(trunc_id - 1)]) + 1)),
          "assigning variable start_t");}
      current_statement__ = 77;
      for (int sym1__ = 1; sym1__ <= obs_sets; ++sym1__) {
        current_statement__ = 77;
        current_statement__ = 77;
        check_greater_or_equal(function__, "end_t[sym1__]",
                               end_t[(sym1__ - 1)], 1);}
      current_statement__ = 79;
      for (int sym1__ = 1; sym1__ <= obs_sets; ++sym1__) {
        current_statement__ = 79;
        current_statement__ = 79;
        check_greater_or_equal(function__, "start_t[sym1__]",
                               start_t[(sym1__ - 1)], 1);}
      current_statement__ = 87;
      validate_non_negative_index("delay_mean", "delay_n_p", delay_n_p);
      current_statement__ = 88;
      validate_non_negative_index("delay_sd", "delay_n_p", delay_n_p);
      current_statement__ = 89;
      trunc_obs_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 89;
      trunc_obs_1dim__ = delay_type_max[(trunc_id - 1)];
      current_statement__ = 89;
      validate_non_negative_index("trunc_obs", "delay_type_max[trunc_id]",
                                  trunc_obs_1dim__);
      current_statement__ = 90;
      trunc_obs_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 90;
      trunc_obs_2dim__ = (obs_sets - 1);
      current_statement__ = 90;
      validate_non_negative_index("trunc_obs", "obs_sets - 1",
                                  trunc_obs_2dim__);
      current_statement__ = 91;
      trunc_rev_cmf_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 91;
      trunc_rev_cmf_1dim__ = delay_type_max[(trunc_id - 1)];
      current_statement__ = 91;
      validate_non_negative_index("trunc_rev_cmf",
                                  "delay_type_max[trunc_id]",
                                  trunc_rev_cmf_1dim__);
      current_statement__ = 92;
      recon_obs_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 92;
      recon_obs_1dim__ = delay_type_max[(trunc_id - 1)];
      current_statement__ = 92;
      validate_non_negative_index("recon_obs", "delay_type_max[trunc_id]",
                                  recon_obs_1dim__);
      current_statement__ = 93;
      validate_non_negative_index("recon_obs", "obs_sets", obs_sets);
      current_statement__ = 94;
      gen_obs_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 94;
      gen_obs_1dim__ = delay_type_max[(trunc_id - 1)];
      current_statement__ = 94;
      validate_non_negative_index("gen_obs", "delay_type_max[trunc_id]",
                                  gen_obs_1dim__);
      current_statement__ = 95;
      gen_obs_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 95;
      gen_obs_2dim__ = (obs_sets - 1);
      current_statement__ = 95;
      validate_non_negative_index("gen_obs", "obs_sets - 1", gen_obs_2dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += delay_n_p;
      num_params_r__ += delay_n_p;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_estimate_truncation_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> delay_mean;
      delay_mean = std::vector<local_scalar_t__>(delay_n_p, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 1;
        assign(delay_mean, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable delay_mean");}
      std::vector<local_scalar_t__> delay_sd;
      delay_sd = std::vector<local_scalar_t__>(delay_n_p, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 2;
        assign(delay_sd, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable delay_sd");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(delay_sd, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(delay_sd[(sym1__ - 1)], 0, lp__),
            "assigning variable delay_sd");
        } else {
          current_statement__ = 2;
          assign(delay_sd, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(delay_sd[(sym1__ - 1)], 0),
            "assigning variable delay_sd");
        }}
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 3;
      phi = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        phi = stan::math::lb_constrain(phi, 0, lp__);
      } else {
        current_statement__ = 3;
        phi = stan::math::lb_constrain(phi, 0);
      }
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      local_scalar_t__ sqrt_phi;
      sqrt_phi = DUMMY_VAR__;
      
      current_statement__ = 5;
      sqrt_phi = (1 / stan::math::sqrt(phi));
      Eigen::Matrix<local_scalar_t__, -1, -1> trunc_obs;
      trunc_obs = Eigen::Matrix<local_scalar_t__, -1, -1>(trunc_obs_1dim__, trunc_obs_2dim__);
      stan::math::fill(trunc_obs, DUMMY_VAR__);
      
      current_statement__ = 6;
      assign(trunc_obs, nil_index_list(),
        rep_matrix(0, delay_type_max[(trunc_id - 1)], (obs_sets - 1)),
        "assigning variable trunc_obs");
      Eigen::Matrix<local_scalar_t__, -1, 1> trunc_rev_cmf;
      trunc_rev_cmf = Eigen::Matrix<local_scalar_t__, -1, 1>(trunc_rev_cmf_1dim__);
      stan::math::fill(trunc_rev_cmf, DUMMY_VAR__);
      
      current_statement__ = 7;
      assign(trunc_rev_cmf, nil_index_list(),
        get_delay_rev_pmf(trunc_id, delay_type_max[(trunc_id - 1)],
          delay_types_p, delay_types_id, delay_types_groups, delay_max,
          delay_np_pmf, delay_np_pmf_groups, delay_mean, delay_sd,
          delay_dist, 0, 1, 1, pstream__), "assigning variable trunc_rev_cmf");
      {
        current_statement__ = 8;
        validate_non_negative_index("last_obs", "t", t);
        Eigen::Matrix<local_scalar_t__, -1, 1> last_obs;
        last_obs = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
        stan::math::fill(last_obs, DUMMY_VAR__);
        
        current_statement__ = 10;
        assign(last_obs, nil_index_list(),
          truncate(
            to_vector(
              rvalue(obs,
                cons_list(index_omni(),
                  cons_list(index_uni(obs_sets), nil_index_list())), "obs")),
            trunc_rev_cmf, 1, pstream__), "assigning variable last_obs");
        current_statement__ = 13;
        for (int i = 1; i <= (obs_sets - 1); ++i) {
          current_statement__ = 11;
          assign(trunc_obs,
            cons_list(
              index_min_max(1, ((end_t[(i - 1)] - start_t[(i - 1)]) + 1)),
              cons_list(index_uni(i), nil_index_list())),
            add(
              truncate(
                rvalue(last_obs,
                  cons_list(index_min_max(start_t[(i - 1)], end_t[(i - 1)]),
                    nil_index_list()), "last_obs"), trunc_rev_cmf,
                0, pstream__), sigma), "assigning variable trunc_obs");}
      }
      {
        current_statement__ = 29;
        delays_lp<false>(delay_mean, delay_mean_mean, delay_mean_sd,
          delay_sd, delay_sd_mean, delay_sd_sd, delay_dist,
          delay_weight, lp__, lp_accum__, pstream__);
        current_statement__ = 30;
        if (logical_lt(phi, 0)) {
          current_statement__ = 30;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 30;
          lp_accum__.add(-normal_ccdf_log(0, 0, 1));
        }
        current_statement__ = 31;
        lp_accum__.add(normal_lpdf<propto__>(phi, 0, 1));
        current_statement__ = 32;
        if (logical_lt(sigma, 0)) {
          current_statement__ = 32;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 32;
          lp_accum__.add(-normal_ccdf_log(0, 0, 1));
        }
        current_statement__ = 33;
        lp_accum__.add(normal_lpdf<propto__>(sigma, 0, 1));
        current_statement__ = 38;
        for (int i = 1; i <= (obs_sets - 1); ++i) {
          current_statement__ = 36;
          for (int j = 1; j <= ((end_t[(i - 1)] - start_t[(i - 1)]) + 1); ++j) {
            current_statement__ = 34;
            lp_accum__.add(
              neg_binomial_2_lpmf<propto__>(
                obs[(((start_t[(i - 1)] + j) - 1) - 1)][(i - 1)],
                rvalue(trunc_obs,
                  cons_list(index_uni(j),
                    cons_list(index_uni(i), nil_index_list())), "trunc_obs"),
                sqrt_phi));}}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_estimate_truncation_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> delay_mean;
      delay_mean = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 1;
        assign(delay_mean, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable delay_mean");}
      std::vector<double> delay_sd;
      delay_sd = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 2;
        assign(delay_sd, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable delay_sd");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 2;
        assign(delay_sd, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(delay_sd[(sym1__ - 1)], 0),
          "assigning variable delay_sd");}
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      phi = in__.scalar();
      current_statement__ = 3;
      phi = stan::math::lb_constrain(phi, 0);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      sigma = stan::math::lb_constrain(sigma, 0);
      double sqrt_phi;
      sqrt_phi = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, -1> trunc_obs;
      trunc_obs = Eigen::Matrix<double, -1, -1>(trunc_obs_1dim__, trunc_obs_2dim__);
      stan::math::fill(trunc_obs, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> trunc_rev_cmf;
      trunc_rev_cmf = Eigen::Matrix<double, -1, 1>(trunc_rev_cmf_1dim__);
      stan::math::fill(trunc_rev_cmf, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        vars__.emplace_back(delay_mean[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        vars__.emplace_back(delay_sd[(sym1__ - 1)]);}
      vars__.emplace_back(phi);
      vars__.emplace_back(sigma);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 5;
      sqrt_phi = (1 / stan::math::sqrt(phi));
      current_statement__ = 6;
      assign(trunc_obs, nil_index_list(),
        rep_matrix(0, delay_type_max[(trunc_id - 1)], (obs_sets - 1)),
        "assigning variable trunc_obs");
      current_statement__ = 7;
      assign(trunc_rev_cmf, nil_index_list(),
        get_delay_rev_pmf(trunc_id, delay_type_max[(trunc_id - 1)],
          delay_types_p, delay_types_id, delay_types_groups, delay_max,
          delay_np_pmf, delay_np_pmf_groups, delay_mean, delay_sd,
          delay_dist, 0, 1, 1, pstream__), "assigning variable trunc_rev_cmf");
      {
        current_statement__ = 8;
        validate_non_negative_index("last_obs", "t", t);
        Eigen::Matrix<double, -1, 1> last_obs;
        last_obs = Eigen::Matrix<double, -1, 1>(t);
        stan::math::fill(last_obs, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 10;
        assign(last_obs, nil_index_list(),
          truncate(
            to_vector(
              rvalue(obs,
                cons_list(index_omni(),
                  cons_list(index_uni(obs_sets), nil_index_list())), "obs")),
            trunc_rev_cmf, 1, pstream__), "assigning variable last_obs");
        current_statement__ = 13;
        for (int i = 1; i <= (obs_sets - 1); ++i) {
          current_statement__ = 11;
          assign(trunc_obs,
            cons_list(
              index_min_max(1, ((end_t[(i - 1)] - start_t[(i - 1)]) + 1)),
              cons_list(index_uni(i), nil_index_list())),
            add(
              truncate(
                rvalue(last_obs,
                  cons_list(index_min_max(start_t[(i - 1)], end_t[(i - 1)]),
                    nil_index_list()), "last_obs"), trunc_rev_cmf,
                0, pstream__), sigma), "assigning variable trunc_obs");}
      }
      if (emit_transformed_parameters__) {
        vars__.emplace_back(sqrt_phi);
        for (int sym1__ = 1; sym1__ <= trunc_obs_2dim__; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= trunc_obs_1dim__; ++sym2__) {
            vars__.emplace_back(
              rvalue(trunc_obs,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "trunc_obs"));}}
        for (int sym1__ = 1; sym1__ <= trunc_rev_cmf_1dim__; ++sym1__) {
          vars__.emplace_back(trunc_rev_cmf[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, -1> recon_obs;
      recon_obs = Eigen::Matrix<double, -1, -1>(recon_obs_1dim__, obs_sets);
      stan::math::fill(recon_obs, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 15;
      assign(recon_obs, nil_index_list(),
        rep_matrix(0, delay_type_max[(trunc_id - 1)], obs_sets),
        "assigning variable recon_obs");
      Eigen::Matrix<double, -1, -1> gen_obs;
      gen_obs = Eigen::Matrix<double, -1, -1>(gen_obs_1dim__, gen_obs_2dim__);
      stan::math::fill(gen_obs, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 19;
      for (int i = 1; i <= obs_sets; ++i) {
        current_statement__ = 17;
        assign(recon_obs,
          cons_list(
            index_min_max(1, ((end_t[(i - 1)] - start_t[(i - 1)]) + 1)),
            cons_list(index_uni(i), nil_index_list())),
          truncate(
            to_vector(
              rvalue(obs,
                cons_list(index_min_max(start_t[(i - 1)], end_t[(i - 1)]),
                  cons_list(index_uni(i), nil_index_list())), "obs")),
            trunc_rev_cmf, 1, pstream__), "assigning variable recon_obs");}
      current_statement__ = 28;
      for (int i = 1; i <= (obs_sets - 1); ++i) {
        current_statement__ = 26;
        for (int j = 1; j <= delay_type_max[(trunc_id - 1)]; ++j) {
          current_statement__ = 24;
          if (logical_eq(
                rvalue(trunc_obs,
                  cons_list(index_uni(j),
                    cons_list(index_uni(i), nil_index_list())), "trunc_obs"),
                0)) {
            current_statement__ = 22;
            assign(gen_obs,
              cons_list(index_uni(j),
                cons_list(index_uni(i), nil_index_list())), 0,
              "assigning variable gen_obs");
          } else {
            current_statement__ = 20;
            assign(gen_obs,
              cons_list(index_uni(j),
                cons_list(index_uni(i), nil_index_list())),
              neg_binomial_2_rng(
                rvalue(trunc_obs,
                  cons_list(index_uni(j),
                    cons_list(index_uni(i), nil_index_list())), "trunc_obs"),
                sqrt_phi, base_rng__), "assigning variable gen_obs");
          }}}
      for (int sym1__ = 1; sym1__ <= obs_sets; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= recon_obs_1dim__; ++sym2__) {
          vars__.emplace_back(
            rvalue(recon_obs,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "recon_obs"));
        }}
      for (int sym1__ = 1; sym1__ <= gen_obs_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= gen_obs_1dim__; ++sym2__) {
          vars__.emplace_back(
            rvalue(gen_obs,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "gen_obs"));
        }}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> delay_mean;
      delay_mean = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(delay_mean, nil_index_list(), context__.vals_r("delay_mean"),
        "assigning variable delay_mean");
      std::vector<double> delay_sd;
      delay_sd = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(delay_sd, nil_index_list(), context__.vals_r("delay_sd"),
        "assigning variable delay_sd");
      std::vector<double> delay_sd_free__;
      delay_sd_free__ = std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 2;
        assign(delay_sd_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(delay_sd[(sym1__ - 1)], 0),
          "assigning variable delay_sd_free__");}
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      phi = context__.vals_r("phi")[(1 - 1)];
      double phi_free__;
      phi_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      phi_free__ = stan::math::lb_free(phi, 0);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        vars__.emplace_back(delay_mean[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        vars__.emplace_back(delay_sd_free__[(sym1__ - 1)]);}
      vars__.emplace_back(phi_free__);
      vars__.emplace_back(sigma_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("delay_mean");
    names__.emplace_back("delay_sd");
    names__.emplace_back("phi");
    names__.emplace_back("sigma");
    names__.emplace_back("sqrt_phi");
    names__.emplace_back("trunc_obs");
    names__.emplace_back("trunc_rev_cmf");
    names__.emplace_back("recon_obs");
    names__.emplace_back("gen_obs");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(delay_n_p)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(delay_n_p)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(trunc_obs_1dim__)
                                             ,
                                             static_cast<size_t>(trunc_obs_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(trunc_rev_cmf_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(recon_obs_1dim__)
                                             , static_cast<size_t>(obs_sets)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gen_obs_1dim__)
                                             ,
                                             static_cast<size_t>(gen_obs_2dim__)
                                             });
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delay_mean" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delay_sd" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "sqrt_phi");
      for (int sym1__ = 1; sym1__ <= trunc_obs_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= trunc_obs_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "trunc_obs" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= trunc_rev_cmf_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "trunc_rev_cmf" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= obs_sets; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= recon_obs_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "recon_obs" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= gen_obs_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= gen_obs_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "gen_obs" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delay_mean" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delay_sd" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "sqrt_phi");
      for (int sym1__ = 1; sym1__ <= trunc_obs_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= trunc_obs_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "trunc_obs" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= trunc_rev_cmf_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "trunc_rev_cmf" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= obs_sets; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= recon_obs_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "recon_obs" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= gen_obs_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= gen_obs_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "gen_obs" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"delay_mean\",\"type\":{\"name\":\"array\",\"length\":" << delay_n_p << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"delay_sd\",\"type\":{\"name\":\"array\",\"length\":" << delay_n_p << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sqrt_phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"trunc_obs\",\"type\":{\"name\":\"matrix\",\"rows\":" << trunc_obs_1dim__ << ",\"cols\":" << trunc_obs_2dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"trunc_rev_cmf\",\"type\":{\"name\":\"vector\",\"length\":" << trunc_rev_cmf_1dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"recon_obs\",\"type\":{\"name\":\"matrix\",\"rows\":" << recon_obs_1dim__ << ",\"cols\":" << obs_sets << "},\"block\":\"generated_quantities\"},{\"name\":\"gen_obs\",\"type\":{\"name\":\"matrix\",\"rows\":" << gen_obs_1dim__ << ",\"cols\":" << gen_obs_2dim__ << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"delay_mean\",\"type\":{\"name\":\"array\",\"length\":" << delay_n_p << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"delay_sd\",\"type\":{\"name\":\"array\",\"length\":" << delay_n_p << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sqrt_phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"trunc_obs\",\"type\":{\"name\":\"matrix\",\"rows\":" << trunc_obs_1dim__ << ",\"cols\":" << trunc_obs_2dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"trunc_rev_cmf\",\"type\":{\"name\":\"vector\",\"length\":" << trunc_rev_cmf_1dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"recon_obs\",\"type\":{\"name\":\"matrix\",\"rows\":" << recon_obs_1dim__ << ",\"cols\":" << obs_sets << "},\"block\":\"generated_quantities\"},{\"name\":\"gen_obs\",\"type\":{\"name\":\"matrix\",\"rows\":" << gen_obs_1dim__ << ",\"cols\":" << gen_obs_2dim__ << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_estimate_truncation_namespace::model_estimate_truncation;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_estimate_truncation_namespace::profiles__;
}
#endif
#endif
