% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selecao.R
\name{COI}
\alias{COI}
\title{Inbreeding coefficient}
\usage{
COI(var, VG, VF, generation = "all", verbose = FALSE)
}
\arguments{
\item{var}{Column with the variable name}

\item{VG}{Column with genotypic variance}

\item{VF}{Column with phenotypic variance}

\item{generation}{Parameter to select the generation. Use 'all' to get the
parameters for all the generations or 'F3', 'F4', 'F5' and 'F6' for just
 one of the generations.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
Returns the total, additive and dominance variance values based on
the variance components for a given variable.
}
\description{
Function for calculating the inbreeding coefficient
}
\examples{
library(EstimateBreed)

var <- c("A","B","C","D","E")
VF <- c(2.5, 3.0, 2.8, 3.2, 2.7)
VG <- c(1.2, 1.5, 1.3, 1.6, 1.4)
data <- data.frame(var,VG,VF)

#Calculating for all generations
inbr1 <- with(data,COI(var,VG,VF,generation = "all"))

#Calculating for just one generation
inbr2 <- with(data,COI(var,VG,VF,generation = "F3"))
}
\references{
Falconer, D. S., & Mackay, T. F. C. (1996). Introduction to quantitative
genetics (4th ed.). Longman.
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
