% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Get_OB.R
\name{EN_Get_OB}
\alias{EN_Get_OB}
\title{Get Order Book Data}
\usage{
EN_Get_OB(ticker, stock_type = "Equity")
}
\arguments{
\item{ticker}{A character string representing the company's (Equity or Etf) ticker, name, or ISIN.}

\item{stock_type}{The type of the ticker: 'Equity' for Stocks and 'Etf' for EFTs.}
}
\value{
A data frame containing order book data with columns:
\itemize{
\item B_order: Buy order number
\item B_quantity: Buy order quantity
\item Bid_Price: Bid price
\item Ask_Price: Ask price
\item A_quantity: Ask order quantity
\item A_order: Ask order number
If the specified ticker is not found, the function returns an error message.
}
}
\description{
This function retrieves the order book data for a given stock or Etf ticker on the Euronext exchange.
It provides information about the buy and sell orders, including the order quantity and price.
The data is returned as a data frame with columns representing buy (bid) and sell (ask) orders.
The last row of the data frame contains the sum of elements for each column (excluding "Bid_Price" and "Ask_Price" columns marked with "-").
}
\examples{

library(httr)
library(jsonlite)
library(dplyr)
library(magrittr)
library(rvest)
library(stringr)

ABCA_OB = EN_Get_OB("ABCA") # Get ABC ARBITRAGE ticker ORDER BOOK
print(ABCA_OB)

MSFT_OB = EN_Get_OB("MSFT", stock_type = 'Etf')
print(MSFT_OB)

# Get ETf 'AAPL' ORDER BOOK by providing its DNA
# EN_Get_OB("XS2337099563-XAMS", stock_type = 'Etf')

# Get ETf 'LEVERAGE SHARES PLC' ORDER BOOK by providing its DNA
# EN_Get_OB("XS2663694847-XAMS", stock_type = 'Etf')

ALBON_OB = EN_Get_OB("ALBON") # Get LEBON ticker ORDER BOOK
print(ALBON_OB)

EN_Get_OB("ALBONgdg") # Will return "Ticker not found"

}
\seealso{
\code{\link{EN_GetProfile}} to retrieve the ISIN or DNA for a given ticker.

Other Data Retrieval: 
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\concept{Data Retrieval}
\concept{Euronext}
