% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene.evaluate.core.R
\name{levene.evaluate.core}
\alias{levene.evaluate.core}
\title{Levene's Test}
\usage{
levene.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A data frame with the following columns \item{Trait}{The quantitative
  trait.} \item{EC_V}{The variance of the EC.} \item{CS_V}{The variance of
  the CS.} \item{EC_CV}{The coefficient of variance of the EC.}
  \item{CS_CV}{The coefficient of variance of the CS.}
  \item{Levene_Fvalue}{The test statistic.} \item{Levene_pvalue}{The p value
  for the test statistic.} \item{Levene_significance}{The significance of the
  test statistic (*: p \mjseqn{\leq} 0.01; **: p \mjseqn{\leq} 0.05; ns: p
  \mjseqn{ > } 0.05).}
}
\description{
Test for  of variances of the entire collection (EC) and core set (CS) for
quantitative traits by Levene's test
\insertCite{levene_robust_1960}{EvaluateCore}. \loadmathjax
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

levene.evaluate.core(data = ec, names = "genotypes",
                     quantitative = quant, selected = core)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[car]{leveneTest}}
}
