% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BR.R
\name{BR}
\alias{BR}
\title{BR dynamic}
\usage{
BR(time, state, parameters)
}
\arguments{
\item{time}{Regular sequence that represents the time sequence under which
simulation takes place.}

\item{state}{Numeric vector that represents the initial state.}

\item{parameters}{Numeric vector that represents parameters needed by the
dynamic.}
}
\value{
Numeric list. Each component represents the rate of change depending on
 the dynamic.
}
\description{
Best response dynamic as a type of evolutionary dynamics.
}
\examples{
dynamic <- BR
A <- matrix(c(0, -2, 1, 1, 0, -2, -2, 1, 0), 3, byrow=TRUE)
state <- matrix(c(0.4, 0.3, 0.3), 1, 3, byrow=TRUE)
phaseDiagram3S(A, dynamic, NULL, state, FALSE, FALSE)
}
\references{
Gilboa, I. and Matsui, A. (1991)
"Social Stability and Equilibrium",
Econometrica 59, pp. 859--867.
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
